/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.sqlclient;

import io.reactivex.Completable;
import io.vertx.core.Future;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.sqlclient.SqlClient;

@RxGen(value=io.vertx.ext.auth.sqlclient.SqlUserUtil.class)
public class SqlUserUtil {
    public static final TypeArg<SqlUserUtil> __TYPE_ARG = new TypeArg(obj -> new SqlUserUtil((io.vertx.ext.auth.sqlclient.SqlUserUtil)obj), SqlUserUtil::getDelegate);
    private final io.vertx.ext.auth.sqlclient.SqlUserUtil delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlUserUtil that = (SqlUserUtil)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SqlUserUtil(io.vertx.ext.auth.sqlclient.SqlUserUtil delegate) {
        this.delegate = delegate;
    }

    public SqlUserUtil(Object delegate) {
        this.delegate = (io.vertx.ext.auth.sqlclient.SqlUserUtil)delegate;
    }

    public io.vertx.ext.auth.sqlclient.SqlUserUtil getDelegate() {
        return this.delegate;
    }

    public static SqlUserUtil create(SqlClient client) {
        SqlUserUtil ret = SqlUserUtil.newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil.create((io.vertx.sqlclient.SqlClient)client.getDelegate()));
        return ret;
    }

    public static SqlUserUtil create(SqlClient client, String insertUserSQL, String insertUserRoleSQL, String insertRolePermissionSQL) {
        SqlUserUtil ret = SqlUserUtil.newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil.create((io.vertx.sqlclient.SqlClient)client.getDelegate(), (String)insertUserSQL, (String)insertUserRoleSQL, (String)insertRolePermissionSQL));
        return ret;
    }

    public Future<Void> createUser(String username, String password) {
        Future ret = this.delegate.createUser(username, password).map(val -> val);
        return ret;
    }

    public Completable rxCreateUser(String username, String password) {
        return AsyncResultCompletable.toCompletable($handler -> this.createUser(username, password).onComplete($handler));
    }

    public Future<Void> createHashedUser(String username, String hash) {
        Future ret = this.delegate.createHashedUser(username, hash).map(val -> val);
        return ret;
    }

    public Completable rxCreateHashedUser(String username, String hash) {
        return AsyncResultCompletable.toCompletable($handler -> this.createHashedUser(username, hash).onComplete($handler));
    }

    public Future<Void> createUserRole(String username, String role) {
        Future ret = this.delegate.createUserRole(username, role).map(val -> val);
        return ret;
    }

    public Completable rxCreateUserRole(String username, String role) {
        return AsyncResultCompletable.toCompletable($handler -> this.createUserRole(username, role).onComplete($handler));
    }

    public Future<Void> createRolePermission(String role, String permission) {
        Future ret = this.delegate.createRolePermission(role, permission).map(val -> val);
        return ret;
    }

    public Completable rxCreateRolePermission(String role, String permission) {
        return AsyncResultCompletable.toCompletable($handler -> this.createRolePermission(role, permission).onComplete($handler));
    }

    public static SqlUserUtil newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil arg) {
        return arg != null ? new SqlUserUtil(arg) : null;
    }
}

