/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.streams;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;

class ReadStreamImpl<T>
implements ReadStream<T> {
    private final io.vertx.core.streams.ReadStream<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private Observable<T> observable;
    private Flowable<T> flowable;

    public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public ReadStreamImpl(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.core.streams.ReadStream)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    @Override
    public io.vertx.core.streams.ReadStream getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<T> toObservable() {
        if (this.observable == null) {
            Function conv = this.__typeArg_0.wrap;
            this.observable = ObservableHelper.toObservable(this.delegate, (Function)conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<T> toFlowable() {
        if (this.flowable == null) {
            Function conv = this.__typeArg_0.wrap;
            this.flowable = FlowableHelper.toFlowable(this.delegate, (Function)conv);
        }
        return this.flowable;
    }

    @Override
    public ReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public ReadStream<T> handler(Handler<T> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> this.__typeArg_0.wrap(event)));
        return this;
    }

    @Override
    public ReadStream<T> pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public ReadStream<T> resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public ReadStream<T> fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public ReadStream<T> endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public Pipe<T> pipe() {
        Pipe<T> ret = Pipe.newInstance(this.delegate.pipe(), this.__typeArg_0);
        return ret;
    }

    @Override
    public Future<Void> pipeTo(WriteStream<T> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<T> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }
}

