/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqp;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.amqp.AmqpConnection;
import io.vertx.reactivex.amqp.AmqpReceiver;
import io.vertx.reactivex.amqp.AmqpSender;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;
    private static final TypeArg<AmqpConnection> TYPE_ARG_0 = new TypeArg(o1 -> AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpReceiver> TYPE_ARG_1 = new TypeArg(o1 -> AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpReceiver> TYPE_ARG_2 = new TypeArg(o1 -> AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpSender> TYPE_ARG_3 = new TypeArg(o1 -> AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpSender> TYPE_ARG_4 = new TypeArg(o1 -> AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    public AmqpClient(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpClient)delegate;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.reactivex.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    public Future<AmqpConnection> connect() {
        Future ret = this.delegate.connect().map(val -> AmqpConnection.newInstance(val));
        return ret;
    }

    public Single<AmqpConnection> rxConnect() {
        return AsyncResultSingle.toSingle($handler -> this.connect().onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<AmqpReceiver> createReceiver(String address) {
        Future ret = this.delegate.createReceiver(address).map(val -> AmqpReceiver.newInstance(val));
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address).onComplete($handler));
    }

    public Future<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        Future ret = this.delegate.createReceiver(address, receiverOptions).map(val -> AmqpReceiver.newInstance(val));
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address, receiverOptions).onComplete($handler));
    }

    public Future<AmqpSender> createSender(String address) {
        Future ret = this.delegate.createSender(address).map(val -> AmqpSender.newInstance(val));
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address).onComplete($handler));
    }

    public Future<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        Future ret = this.delegate.createSender(address, options).map(val -> AmqpSender.newInstance(val));
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address, options).onComplete($handler));
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

