/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.servicediscovery;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.servicediscovery.ServiceReference;
import io.vertx.reactivex.servicediscovery.spi.ServiceExporter;
import io.vertx.reactivex.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery {
    public static final TypeArg<ServiceDiscovery> __TYPE_ARG = new TypeArg(obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery)obj), ServiceDiscovery::getDelegate);
    private final io.vertx.servicediscovery.ServiceDiscovery delegate;
    private static final TypeArg<ServiceReference> TYPE_ARG_0 = new TypeArg(o1 -> ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)o1), o1 -> o1.getDelegate());
    public static final String EVENT_TYPE = "type";
    public static final String EVENT_TYPE_BIND = "bind";
    public static final String EVENT_TYPE_RELEASE = "release";
    public static final String EVENT_RECORD = "record";
    public static final String EVENT_ID = "id";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDiscovery that = (ServiceDiscovery)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
        this.delegate = delegate;
    }

    public ServiceDiscovery(Object delegate) {
        this.delegate = (io.vertx.servicediscovery.ServiceDiscovery)delegate;
    }

    public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
        return this.delegate;
    }

    public static ServiceDiscovery create(io.vertx.reactivex.core.Vertx vertx, ServiceDiscoveryOptions options) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate(), (ServiceDiscoveryOptions)options));
        return ret;
    }

    public static ServiceDiscovery create(io.vertx.reactivex.core.Vertx vertx) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public ServiceReference getReference(Record record) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReference(record));
        return ret;
    }

    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReferenceWithConfiguration(record, configuration));
        return ret;
    }

    public boolean release(ServiceReference reference) {
        boolean ret = this.delegate.release(reference.getDelegate());
        return ret;
    }

    public Future<Void> registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        Future ret = this.delegate.registerServiceImporter(importer.getDelegate(), configuration).map(val -> val);
        return ret;
    }

    public Completable rxRegisterServiceImporter(ServiceImporter importer, JsonObject configuration) {
        return AsyncResultCompletable.toCompletable($handler -> this.registerServiceImporter(importer, configuration).onComplete($handler));
    }

    public Future<Void> registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        Future ret = this.delegate.registerServiceExporter(exporter.getDelegate(), configuration).map(val -> val);
        return ret;
    }

    public Completable rxRegisterServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        return AsyncResultCompletable.toCompletable($handler -> this.registerServiceExporter(exporter, configuration).onComplete($handler));
    }

    public void close() {
        this.delegate.close();
    }

    public Future<Record> publish(Record record) {
        Future ret = this.delegate.publish(record).map(val -> val);
        return ret;
    }

    public Single<Record> rxPublish(Record record) {
        return AsyncResultSingle.toSingle($handler -> this.publish(record).onComplete($handler));
    }

    public Future<Void> unpublish(String id) {
        Future ret = this.delegate.unpublish(id).map(val -> val);
        return ret;
    }

    public Completable rxUnpublish(String id) {
        return AsyncResultCompletable.toCompletable($handler -> this.unpublish(id).onComplete($handler));
    }

    public Future<Record> getRecord(JsonObject filter) {
        Future ret = this.delegate.getRecord(filter).map(val -> val);
        return ret;
    }

    public Maybe<Record> rxGetRecord(JsonObject filter) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(filter).onComplete($handler));
    }

    public Future<Record> getRecord(String id) {
        Future ret = this.delegate.getRecord(id).map(val -> val);
        return ret;
    }

    public Maybe<Record> rxGetRecord(String id) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(id).onComplete($handler));
    }

    public Future<Record> getRecord(Function<Record, Boolean> filter) {
        Future ret = this.delegate.getRecord(filter).map(val -> val);
        return ret;
    }

    public Maybe<Record> rxGetRecord(Function<Record, Boolean> filter) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(filter).onComplete($handler));
    }

    public Future<Record> getRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        Future ret = this.delegate.getRecord(filter, includeOutOfService).map(val -> val);
        return ret;
    }

    public Maybe<Record> rxGetRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(filter, includeOutOfService).onComplete($handler));
    }

    public Future<List<Record>> getRecords(JsonObject filter) {
        Future ret = this.delegate.getRecords(filter).map(val -> val);
        return ret;
    }

    public Single<List<Record>> rxGetRecords(JsonObject filter) {
        return AsyncResultSingle.toSingle($handler -> this.getRecords(filter).onComplete($handler));
    }

    public Future<List<Record>> getRecords(Function<Record, Boolean> filter) {
        Future ret = this.delegate.getRecords(filter).map(val -> val);
        return ret;
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter) {
        return AsyncResultSingle.toSingle($handler -> this.getRecords(filter).onComplete($handler));
    }

    public Future<List<Record>> getRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        Future ret = this.delegate.getRecords(filter, includeOutOfService).map(val -> val);
        return ret;
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultSingle.toSingle($handler -> this.getRecords(filter, includeOutOfService).onComplete($handler));
    }

    public Future<Record> update(Record record) {
        Future ret = this.delegate.update(record).map(val -> val);
        return ret;
    }

    public Single<Record> rxUpdate(Record record) {
        return AsyncResultSingle.toSingle($handler -> this.update(record).onComplete($handler));
    }

    public Set<ServiceReference> bindings() {
        Set<ServiceReference> ret = this.delegate.bindings().stream().map(elt -> ServiceReference.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public ServiceDiscoveryOptions options() {
        ServiceDiscoveryOptions ret = this.delegate.options();
        return ret;
    }

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (Object)svcObject);
    }

    public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
        return arg != null ? new ServiceDiscovery(arg) : null;
    }
}

