/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.Cookie;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpFrame;
import io.vertx.reactivex.core.http.HttpServerFileUpload;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.net.HostAndPort;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.HttpServerRequest.class)
public class HttpServerRequest
implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<HttpServerRequest> __TYPE_ARG = new TypeArg(obj -> new HttpServerRequest((io.vertx.core.http.HttpServerRequest)obj), HttpServerRequest::getDelegate);
    private final io.vertx.core.http.HttpServerRequest delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Cookie> TYPE_ARG_1 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Cookie> TYPE_ARG_2 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Cookie> TYPE_ARG_3 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private HttpServerResponse cached_0;
    private MultiMap cached_1;
    private MultiMap cached_2;
    private SocketAddress cached_3;
    private SocketAddress cached_4;
    private MultiMap cached_5;
    private Integer cached_6;
    private HttpConnection cached_7;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerRequest that = (HttpServerRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
        this.delegate = delegate;
    }

    public HttpServerRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerRequest)delegate;
    }

    public io.vertx.core.http.HttpServerRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerRequest handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HostAndPort authority() {
        HostAndPort ret = HostAndPort.newInstance(this.delegate.authority());
        return ret;
    }

    @Deprecated
    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public long bytesRead() {
        long ret = this.delegate.bytesRead();
        return ret;
    }

    public HttpServerResponse response() {
        HttpServerResponse ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerResponse.newInstance(this.delegate.response());
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public HttpServerRequest setParamsCharset(String charset) {
        this.delegate.setParamsCharset(charset);
        return this;
    }

    public String getParamsCharset() {
        String ret = this.delegate.getParamsCharset();
        return ret;
    }

    public MultiMap params() {
        MultiMap ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = MultiMap.newInstance(this.delegate.params());
        return ret;
    }

    public String getParam(String paramName) {
        String ret = this.delegate.getParam(paramName);
        return ret;
    }

    public String getParam(String paramName, String defaultValue) {
        String ret = this.delegate.getParam(paramName, defaultValue);
        return ret;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public HttpServerRequest bodyHandler(Handler<io.vertx.reactivex.core.buffer.Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new DelegatingHandler(bodyHandler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    public HttpServerRequest body(Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) {
        HttpServerRequest ret = HttpServerRequest.newInstance(this.delegate.body((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)))));
        return ret;
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end((Handler<AsyncResult<Void>>)$handler));
    }

    public void toNetSocket(Handler<AsyncResult<NetSocket>> handler) {
        this.delegate.toNetSocket((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> NetSocket.newInstance(event))));
    }

    public void toNetSocket() {
        this.toNetSocket((Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxToNetSocket() {
        return AsyncResultSingle.toSingle($handler -> this.toNetSocket((Handler<AsyncResult<NetSocket>>)$handler));
    }

    public HttpServerRequest setExpectMultipart(boolean expect) {
        this.delegate.setExpectMultipart(expect);
        return this;
    }

    public boolean isExpectMultipart() {
        boolean ret = this.delegate.isExpectMultipart();
        return ret;
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> uploadHandler) {
        this.delegate.uploadHandler((Handler)new DelegatingHandler(uploadHandler, event -> HttpServerFileUpload.newInstance(event)));
        return this;
    }

    public MultiMap formAttributes() {
        MultiMap ret;
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        this.cached_5 = ret = MultiMap.newInstance(this.delegate.formAttributes());
        return ret;
    }

    public String getFormAttribute(String attributeName) {
        String ret = this.delegate.getFormAttribute(attributeName);
        return ret;
    }

    public int streamId() {
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        int ret = this.delegate.streamId();
        this.cached_6 = ret;
        return ret;
    }

    public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        this.delegate.toWebSocket((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> ServerWebSocket.newInstance(event))));
    }

    public void toWebSocket() {
        this.toWebSocket((Handler<AsyncResult<ServerWebSocket>>)((Handler)ar -> {}));
    }

    public Single<ServerWebSocket> rxToWebSocket() {
        return AsyncResultSingle.toSingle($handler -> this.toWebSocket((Handler<AsyncResult<ServerWebSocket>>)$handler));
    }

    public boolean isEnded() {
        boolean ret = this.delegate.isEnded();
        return ret;
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler((Handler)new DelegatingHandler(handler, event -> HttpFrame.newInstance(event)));
        return this;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        this.cached_7 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public StreamPriority streamPriority() {
        StreamPriority ret = this.delegate.streamPriority();
        return ret;
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public Cookie getCookie(String name) {
        Cookie ret = Cookie.newInstance(this.delegate.getCookie(name));
        return ret;
    }

    public Cookie getCookie(String name, String domain, String path) {
        Cookie ret = Cookie.newInstance(this.delegate.getCookie(name, domain, path));
        return ret;
    }

    public int cookieCount() {
        int ret = this.delegate.cookieCount();
        return ret;
    }

    @Deprecated
    public Map<String, Cookie> cookieMap() {
        Map<String, Cookie> ret = this.delegate.cookieMap().entrySet().stream().collect(Collectors.toMap(_e -> (String)_e.getKey(), _e -> Cookie.newInstance((io.vertx.core.http.Cookie)_e.getValue())));
        return ret;
    }

    public Set<Cookie> cookies(String name) {
        Set<Cookie> ret = this.delegate.cookies(name).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Set<Cookie> cookies() {
        Set<Cookie> ret = this.delegate.cookies().stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public HttpServerRequest routed(String route) {
        this.delegate.routed(route);
        return this;
    }

    public String getHeader(CharSequence headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
        return arg != null ? new HttpServerRequest(arg) : null;
    }
}

