/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.net.NetServer.class)
public class NetServer
implements RxDelegate,
Measured {
    public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg(obj -> new NetServer((io.vertx.core.net.NetServer)obj), NetServer::getDelegate);
    private final io.vertx.core.net.NetServer delegate;
    private static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetServer that = (NetServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    public NetServer(Object delegate) {
        this.delegate = (io.vertx.core.net.NetServer)delegate;
    }

    public io.vertx.core.net.NetServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Deprecated
    public ReadStream<NetSocket> connectStream() {
        ReadStream<NetSocket> ret = ReadStream.newInstance(this.delegate.connectStream(), TYPE_ARG_0);
        return ret;
    }

    public NetServer connectHandler(Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler(Helper.convertHandler(handler, event -> NetSocket.newInstance(event))));
        return ret;
    }

    public NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(Helper.convertHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event))));
        return this;
    }

    public NetServer listen() {
        return this.listen((Handler<AsyncResult<NetServer>>)((Handler)ar -> {}));
    }

    public Single<NetServer> rxListen() {
        return AsyncResultSingle.toSingle($handler -> this.listen((Handler<AsyncResult<NetServer>>)$handler));
    }

    public NetServer listen(int port, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, host, Helper.convertHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event))));
        return this;
    }

    public NetServer listen(int port, String host) {
        return this.listen(port, host, (Handler<AsyncResult<NetServer>>)((Handler)ar -> {}));
    }

    public Single<NetServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, host, (Handler<AsyncResult<NetServer>>)$handler));
    }

    public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, Helper.convertHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event))));
        return this;
    }

    public NetServer listen(int port) {
        return this.listen(port, (Handler<AsyncResult<NetServer>>)((Handler)ar -> {}));
    }

    public Single<NetServer> rxListen(int port) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, (Handler<AsyncResult<NetServer>>)$handler));
    }

    public NetServer listen(SocketAddress localAddress, Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(localAddress.getDelegate(), Helper.convertHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event))));
        return this;
    }

    public NetServer listen(SocketAddress localAddress) {
        return this.listen(localAddress, (Handler<AsyncResult<NetServer>>)((Handler)ar -> {}));
    }

    public Single<NetServer> rxListen(SocketAddress localAddress) {
        return AsyncResultSingle.toSingle($handler -> this.listen(localAddress, (Handler<AsyncResult<NetServer>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, handler);
    }

    public void updateSSLOptions(SSLOptions options) {
        this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)$handler));
    }

    public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, force, handler);
    }

    public void updateSSLOptions(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)$handler));
    }

    public void updateTrafficShapingOptions(TrafficShapingOptions options) {
        this.delegate.updateTrafficShapingOptions(options);
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

