/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A query for a prepared statement allowing parameterized execution of the query, this query will use
 * a prepared statement.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedQuery original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.PreparedQuery.class)
public class PreparedQuery<T> extends io.vertx.reactivex.sqlclient.Query<T> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedQuery that = (PreparedQuery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PreparedQuery> __TYPE_ARG = new TypeArg<>(    obj -> new PreparedQuery((io.vertx.sqlclient.PreparedQuery) obj),
    PreparedQuery::getDelegate
  );

  private final io.vertx.sqlclient.PreparedQuery<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public PreparedQuery(Object delegate, TypeArg<T> typeArg_0) {
    super((io.vertx.sqlclient.PreparedQuery)delegate);
    this.delegate = (io.vertx.sqlclient.PreparedQuery)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.sqlclient.PreparedQuery getDelegate() {
    return delegate;
  }


  /**
   * Execute the query.
   * @param handler the handler receiving the response
   */
  public void execute(io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.execute(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> (T)__typeArg_0.wrap(event))));
  }

  /**
   * Execute the query.
   */
  public void execute() {
    execute(ar -> { });
  }

  /**
   * Execute the query.
   * @return 
   */
  public io.reactivex.Single<T> rxExecute() { 
    return AsyncResultSingle.toSingle($handler -> {
      execute($handler);
    });
  }

  /**
   * Execute the query.
   * @param tuple 
   * @param handler the handler receiving the response
   */
  public void execute(io.vertx.reactivex.sqlclient.Tuple tuple, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.execute(tuple.getDelegate(), io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> (T)__typeArg_0.wrap(event))));
  }

  /**
   * Execute the query.
   * @param tuple 
   */
  public void execute(io.vertx.reactivex.sqlclient.Tuple tuple) {
    execute(tuple, ar -> { });
  }

  /**
   * Execute the query.
   * @param tuple 
   * @return 
   */
  public io.reactivex.Single<T> rxExecute(io.vertx.reactivex.sqlclient.Tuple tuple) { 
    return AsyncResultSingle.toSingle($handler -> {
      execute(tuple, $handler);
    });
  }

  /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   * @param handler the handler receiving the response
   */
  public void executeBatch(java.util.List<io.vertx.reactivex.sqlclient.Tuple> batch, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.executeBatch(batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> (T)__typeArg_0.wrap(event))));
  }

  /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   */
  public void executeBatch(java.util.List<io.vertx.reactivex.sqlclient.Tuple> batch) {
    executeBatch(batch, ar -> { });
  }

  /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   * @return 
   */
  public io.reactivex.Single<T> rxExecuteBatch(java.util.List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return AsyncResultSingle.toSingle($handler -> {
      executeBatch(batch, $handler);
    });
  }

  /**
   * Use the specified <code>mapper</code> for mapping {@link io.vertx.reactivex.sqlclient.Row} to <code><U></code>.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<U>> mapping(java.util.function.Function<io.vertx.reactivex.sqlclient.Row,U> mapper) { 
    io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<U>> ret = io.vertx.reactivex.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.mapping(new Function<io.vertx.sqlclient.Row,U>() {
      public U apply(io.vertx.sqlclient.Row arg) {
        U ret = mapper.apply(io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)arg));
        return ret;
      }
    }), new TypeArg<io.vertx.reactivex.sqlclient.RowSet<U>>(o0 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.unknown()), o0 -> o0.getDelegate()));
    return ret;
  }

  public static <T> PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg) {
    return arg != null ? new PreparedQuery<T>(arg) : null;
  }

  public static <T> PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new PreparedQuery<T>(arg, __typeArg_T) : null;
  }

}
