/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.pgclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to Postgres.
 * <P>
 *   The connection object supports all the operations defined in the  interface,
 *   it also provides additional support:
 *   <ul>
 *     <li>Notification</li>
 *     <li>Request Cancellation</li>
 *   </ul>
 * </P>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.PgConnection.class)
public class PgConnection extends io.vertx.reactivex.sqlclient.SqlConnection implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgConnection that = (PgConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgConnection> __TYPE_ARG = new TypeArg<>(    obj -> new PgConnection((io.vertx.pgclient.PgConnection) obj),
    PgConnection::getDelegate
  );

  private final io.vertx.pgclient.PgConnection delegate;
  
  public PgConnection(io.vertx.pgclient.PgConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PgConnection(Object delegate) {
    super((io.vertx.pgclient.PgConnection)delegate);
    this.delegate = (io.vertx.pgclient.PgConnection)delegate;
  }

  @Override 
  public io.vertx.pgclient.PgConnection getDelegate() {
    return delegate;
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), options, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)event))));
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) {
    connect(vertx, options, ar -> { });
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.pgclient.PgConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      connect(vertx, options, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   * @param handler 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)event))));
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx) {
    connect(vertx, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.pgclient.PgConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx) { 
    return AsyncResultSingle.toSingle($handler -> {
      connect(vertx, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), connectionUri, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)event))));
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) {
    connect(vertx, connectionUri, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.pgclient.PgConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) { 
    return AsyncResultSingle.toSingle($handler -> {
      connect(vertx, connectionUri, $handler);
    });
  }

  /**
   * Set a handler called when the connection receives notification on a channel.
   * <p/>
   * The handler is called with the {@link io.vertx.pgclient.PgNotification} and has access to the channel name
   * and the notification payload.
   * @param handler the handler
   * @return the transaction instance
   */
  public io.vertx.reactivex.pgclient.PgConnection notificationHandler(io.vertx.core.Handler<io.vertx.pgclient.PgNotification> handler) { 
    delegate.notificationHandler(handler);
    return this;
  }

  /**
   *Set a handler called when the connection receives a notice from the server.
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.pgclient.PgConnection noticeHandler(io.vertx.core.Handler<io.vertx.pgclient.PgNotice> handler) { 
    delegate.noticeHandler(handler);
    return this;
  }

  /**
   * Send a request cancellation message to tell the server to cancel processing request in this connection.
   * <br>Note: Use this with caution because the cancellation signal may or may not have any effect.
   * @param handler the handler notified if cancelling request is sent
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.PgConnection cancelRequest(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    io.vertx.reactivex.pgclient.PgConnection ret = io.vertx.reactivex.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)delegate.cancelRequest(handler));
    return ret;
  }

  /**
   * @return The process ID of the target backend
   */
  public int processId() { 
    int ret = delegate.processId();
    return ret;
  }

  /**
   * @return The secret key for the target backend
   */
  public int secretKey() { 
    int ret = delegate.secretKey();
    return ret;
  }

  /**
   * 
   * @param sql 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.pgclient.PgConnection prepare(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    return this;
  }

  /**
   * 
   * @param sql 
   * @return 
   */
  public io.vertx.reactivex.pgclient.PgConnection prepare(java.lang.String sql) {
    return 
prepare(sql, ar -> { });
  }

  /**
   * 
   * @param sql 
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      prepare(sql, $handler);
    });
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.pgclient.PgConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.pgclient.PgConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Cast a  to {@link io.vertx.reactivex.pgclient.PgConnection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.reactivex.pgclient.PgConnection instance}
   */
  public static io.vertx.reactivex.pgclient.PgConnection cast(io.vertx.reactivex.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.reactivex.pgclient.PgConnection ret = io.vertx.reactivex.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)io.vertx.pgclient.PgConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static PgConnection newInstance(io.vertx.pgclient.PgConnection arg) {
    return arg != null ? new PgConnection(arg) : null;
  }

}
