/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A builder for {@link io.vertx.reactivex.core.http.HttpClient}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpClientBuilder.class)
public class HttpClientBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientBuilder that = (HttpClientBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpClientBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new HttpClientBuilder((io.vertx.core.http.HttpClientBuilder) obj),
    HttpClientBuilder::getDelegate
  );

  private final io.vertx.core.http.HttpClientBuilder delegate;
  
  public HttpClientBuilder(io.vertx.core.http.HttpClientBuilder delegate) {
    this.delegate = delegate;
  }

  public HttpClientBuilder(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpClientBuilder)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpClientBuilder getDelegate() {
    return delegate;
  }

  /**
   * Configure the client options.
   * @param options the client options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpClientBuilder with(io.vertx.core.http.HttpClientOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Configure the client with the given pool <code>options</code>.
   * @param options the pool options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpClientBuilder with(io.vertx.core.http.PoolOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Set a connection handler for the client. This handler is called when a new connection is established.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpClientBuilder withConnectHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpConnection> handler) { 
    delegate.withConnectHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event)));
    return this;
  }

  /**
   * Set a redirect handler for the http client.
   * <p>
   * The redirect handler is called when a <code>3xx</code> response is received and the request is configured to
   * follow redirects with {@link io.vertx.reactivex.core.http.HttpClientRequest#setFollowRedirects}.
   * <p>
   * The redirect handler is passed the {@link io.vertx.reactivex.core.http.HttpClientResponse}, it can return an {@link io.vertx.reactivex.core.http.HttpClientRequest} or <code>null</code>.
   * <ul>
   *   <li>when null is returned, the original response is processed by the original request response handler</li>
   *   <li>when a new <code>Future<HttpClientRequest></code> is returned, the client will send this new request</li>
   * </ul>
   * The new request will get a copy of the previous request headers unless headers are set. In this case,
   * the client assumes that the redirect handler exclusively managers the headers of the new request.
   * <p>
   * The handler must return a <code>Future<HttpClientRequest></code> unsent so the client can further configure it and send it.
   * @param handler the new redirect handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpClientBuilder withRedirectHandler(java.util.function.Function<io.vertx.reactivex.core.http.HttpClientResponse,io.vertx.core.Future<io.vertx.core.http.RequestOptions>> handler) { 
    delegate.withRedirectHandler(new Function<io.vertx.core.http.HttpClientResponse,io.vertx.core.Future<io.vertx.core.http.RequestOptions>>() {
      public io.vertx.core.Future<io.vertx.core.http.RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
        io.vertx.core.Future<io.vertx.core.http.RequestOptions> ret = handler.apply(io.vertx.reactivex.core.http.HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)arg));
        return ret.map(val -> val);
      }
    });
    return this;
  }

  /**
   * Set a redirect handler for the http client.
   * <p>
   * The redirect handler is called when a <code>3xx</code> response is received and the request is configured to
   * follow redirects with {@link io.vertx.reactivex.core.http.HttpClientRequest#setFollowRedirects}.
   * <p>
   * The redirect handler is passed the {@link io.vertx.reactivex.core.http.HttpClientResponse}, it can return an {@link io.vertx.reactivex.core.http.HttpClientRequest} or <code>null</code>.
   * <ul>
   *   <li>when null is returned, the original response is processed by the original request response handler</li>
   *   <li>when a new <code>Future<HttpClientRequest></code> is returned, the client will send this new request</li>
   * </ul>
   * The new request will get a copy of the previous request headers unless headers are set. In this case,
   * the client assumes that the redirect handler exclusively managers the headers of the new request.
   * <p>
   * The handler must return a <code>Future<HttpClientRequest></code> unsent so the client can further configure it and send it.
   * @param handler the new redirect handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpClientBuilder withRedirectHandler(io.reactivex.functions.Function<io.vertx.reactivex.core.http.HttpClientResponse,io.reactivex.Single<io.vertx.core.http.RequestOptions>> handler) { 
    delegate.withRedirectHandler(new Function<io.vertx.core.http.HttpClientResponse,io.vertx.core.Future<io.vertx.core.http.RequestOptions>>() {
      public io.vertx.core.Future<io.vertx.core.http.RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
        io.reactivex.Single<io.vertx.core.http.RequestOptions> ret;
        try {
          ret = handler.apply(io.vertx.reactivex.core.http.HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return this;
  }

  /**
   * Build and return the client.
   * @return the client as configured by this builder
   */
  public io.vertx.reactivex.core.http.HttpClient build() { 
    io.vertx.reactivex.core.http.HttpClient ret = io.vertx.reactivex.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)delegate.build());
    return ret;
  }

  public static HttpClientBuilder newInstance(io.vertx.core.http.HttpClientBuilder arg) {
    return arg != null ? new HttpClientBuilder(arg) : null;
  }

}
