/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.validation.ValidatableResponse.class)
public class ValidatableResponse implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidatableResponse that = (ValidatableResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ValidatableResponse> __TYPE_ARG = new TypeArg<>(    obj -> new ValidatableResponse((io.vertx.openapi.validation.ValidatableResponse) obj),
    ValidatableResponse::getDelegate
  );

  private final io.vertx.openapi.validation.ValidatableResponse delegate;
  
  public ValidatableResponse(io.vertx.openapi.validation.ValidatableResponse delegate) {
    this.delegate = delegate;
  }

  public ValidatableResponse(Object delegate) {
    this.delegate = (io.vertx.openapi.validation.ValidatableResponse)delegate;
  }

  @Override 
  public io.vertx.openapi.validation.ValidatableResponse getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.validation.ResponseParameter> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.validation.ResponseParameter>(o1 -> io.vertx.reactivex.openapi.validation.ResponseParameter.newInstance((io.vertx.openapi.validation.ResponseParameter)o1), o1 -> o1.getDelegate());

  /**
   * Creates a new {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object based on the passed parameters.
   * @param statusCode The related status code
   * @return a {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object
   */
  public static io.vertx.reactivex.openapi.validation.ValidatableResponse create(int statusCode) { 
    io.vertx.reactivex.openapi.validation.ValidatableResponse ret = io.vertx.reactivex.openapi.validation.ValidatableResponse.newInstance((io.vertx.openapi.validation.ValidatableResponse)io.vertx.openapi.validation.ValidatableResponse.create(statusCode));
    return ret;
  }

  /**
   * Creates a new {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object based on the passed parameters.
   * @param statusCode The related status code
   * @param headers The related headers
   * @return a {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object
   */
  public static io.vertx.reactivex.openapi.validation.ValidatableResponse create(int statusCode, java.util.Map<java.lang.String,java.lang.String> headers) { 
    io.vertx.reactivex.openapi.validation.ValidatableResponse ret = io.vertx.reactivex.openapi.validation.ValidatableResponse.newInstance((io.vertx.openapi.validation.ValidatableResponse)io.vertx.openapi.validation.ValidatableResponse.create(statusCode, headers));
    return ret;
  }

  /**
   * Creates a new {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object based on the passed parameters.
   * @param statusCode The related status code
   * @param body The related body
   * @param contentType The related content type
   * @return a {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object
   */
  public static io.vertx.reactivex.openapi.validation.ValidatableResponse create(int statusCode, io.vertx.reactivex.core.buffer.Buffer body, java.lang.String contentType) { 
    io.vertx.reactivex.openapi.validation.ValidatableResponse ret = io.vertx.reactivex.openapi.validation.ValidatableResponse.newInstance((io.vertx.openapi.validation.ValidatableResponse)io.vertx.openapi.validation.ValidatableResponse.create(statusCode, body.getDelegate(), contentType));
    return ret;
  }

  /**
   * Creates a new {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object based on the passed parameters.
   * <p>
   * @param statusCode The related status code
   * @param headers The related headers
   * @param body The related body
   * @param contentType The related content type
   * @return a {@link io.vertx.reactivex.openapi.validation.ValidatableResponse} object
   */
  public static io.vertx.reactivex.openapi.validation.ValidatableResponse create(int statusCode, java.util.Map<java.lang.String,java.lang.String> headers, io.vertx.reactivex.core.buffer.Buffer body, java.lang.String contentType) { 
    io.vertx.reactivex.openapi.validation.ValidatableResponse ret = io.vertx.reactivex.openapi.validation.ValidatableResponse.newInstance((io.vertx.openapi.validation.ValidatableResponse)io.vertx.openapi.validation.ValidatableResponse.create(statusCode, headers, body.getDelegate(), contentType));
    return ret;
  }

  /**
   * @return the header parameters.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.ResponseParameter> getHeaders() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.ResponseParameter> ret = delegate.getHeaders().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.validation.ResponseParameter.newInstance((io.vertx.openapi.validation.ResponseParameter)_e.getValue())));
    return ret;
  }

  /**
   * @return the body.
   */
  public io.vertx.reactivex.openapi.validation.ResponseParameter getBody() { 
    io.vertx.reactivex.openapi.validation.ResponseParameter ret = io.vertx.reactivex.openapi.validation.ResponseParameter.newInstance((io.vertx.openapi.validation.ResponseParameter)delegate.getBody());
    return ret;
  }

  public java.lang.String getContentType() { 
    java.lang.String ret = delegate.getContentType();
    return ret;
  }

  public int getStatusCode() { 
    int ret = delegate.getStatusCode();
    return ret;
  }

  public static ValidatableResponse newInstance(io.vertx.openapi.validation.ValidatableResponse arg) {
    return arg != null ? new ValidatableResponse(arg) : null;
  }

}
