/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.contract.OpenAPIContract.class)
public class OpenAPIContract implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenAPIContract that = (OpenAPIContract) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OpenAPIContract> __TYPE_ARG = new TypeArg<>(    obj -> new OpenAPIContract((io.vertx.openapi.contract.OpenAPIContract) obj),
    OpenAPIContract::getDelegate
  );

  private final io.vertx.openapi.contract.OpenAPIContract delegate;
  
  public OpenAPIContract(io.vertx.openapi.contract.OpenAPIContract delegate) {
    this.delegate = delegate;
  }

  public OpenAPIContract(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.OpenAPIContract)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.OpenAPIContract getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract>(o1 -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract>(o1 -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract>(o1 -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.openapi.contract.OpenAPIContract>(o1 -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.Operation> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.openapi.contract.Operation>(o1 -> io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.Path> TYPE_ARG_5 = new TypeArg<io.vertx.reactivex.openapi.contract.Path>(o1 -> io.vertx.reactivex.openapi.contract.Path.newInstance((io.vertx.openapi.contract.Path)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.Server> TYPE_ARG_6 = new TypeArg<io.vertx.reactivex.openapi.contract.Server>(o1 -> io.vertx.reactivex.openapi.contract.Server.newInstance((io.vertx.openapi.contract.Server)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.SecurityRequirement> TYPE_ARG_7 = new TypeArg<io.vertx.reactivex.openapi.contract.SecurityRequirement>(o1 -> io.vertx.reactivex.openapi.contract.SecurityRequirement.newInstance((io.vertx.openapi.contract.SecurityRequirement)o1), o1 -> o1.getDelegate());

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContractPath The path to the unresolved contract.
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> from(io.vertx.reactivex.core.Vertx vertx, java.lang.String unresolvedContractPath) { 
    io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> ret = io.vertx.openapi.contract.OpenAPIContract.from(vertx.getDelegate(), unresolvedContractPath).map(val -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)val));
    return ret;
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContractPath The path to the unresolved contract.
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.reactivex.Single<io.vertx.reactivex.openapi.contract.OpenAPIContract> rxFrom(io.vertx.reactivex.core.Vertx vertx, java.lang.String unresolvedContractPath) { 
    return AsyncResultSingle.toSingle($handler -> {
      from(vertx, unresolvedContractPath).onComplete($handler);
    });
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContract The unresolved contract.
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> from(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject unresolvedContract) { 
    io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> ret = io.vertx.openapi.contract.OpenAPIContract.from(vertx.getDelegate(), unresolvedContract).map(val -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)val));
    return ret;
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContract The unresolved contract.
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.reactivex.Single<io.vertx.reactivex.openapi.contract.OpenAPIContract> rxFrom(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject unresolvedContract) { 
    return AsyncResultSingle.toSingle($handler -> {
      from(vertx, unresolvedContract).onComplete($handler);
    });
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * <p>
   * This method can be used in case that the contract is split into several files. These files can be passed in a
   * Map that has the reference as key and the path to the file as value.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContractPath The path to the unresolved contract.
   * @param additionalContractFiles The additional contract files
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> from(io.vertx.reactivex.core.Vertx vertx, java.lang.String unresolvedContractPath, java.util.Map<java.lang.String,java.lang.String> additionalContractFiles) { 
    io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> ret = io.vertx.openapi.contract.OpenAPIContract.from(vertx.getDelegate(), unresolvedContractPath, additionalContractFiles).map(val -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)val));
    return ret;
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * <p>
   * This method can be used in case that the contract is split into several files. These files can be passed in a
   * Map that has the reference as key and the path to the file as value.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContractPath The path to the unresolved contract.
   * @param additionalContractFiles The additional contract files
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.reactivex.Single<io.vertx.reactivex.openapi.contract.OpenAPIContract> rxFrom(io.vertx.reactivex.core.Vertx vertx, java.lang.String unresolvedContractPath, java.util.Map<java.lang.String,java.lang.String> additionalContractFiles) { 
    return AsyncResultSingle.toSingle($handler -> {
      from(vertx, unresolvedContractPath, additionalContractFiles).onComplete($handler);
    });
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * <p>
   * This method can be used in case that the contract is split into several files. These files can be passed in a
   * Map that has the reference as key and the path to the file as value.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContract The unresolved contract.
   * @param additionalContractFiles The additional contract files
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> from(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject unresolvedContract, java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> additionalContractFiles) { 
    io.vertx.core.Future<io.vertx.reactivex.openapi.contract.OpenAPIContract> ret = io.vertx.openapi.contract.OpenAPIContract.from(vertx.getDelegate(), unresolvedContract, additionalContractFiles).map(val -> io.vertx.reactivex.openapi.contract.OpenAPIContract.newInstance((io.vertx.openapi.contract.OpenAPIContract)val));
    return ret;
  }

  /**
   * Resolves / dereferences the passed contract and creates an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance.
   * <p>
   * This method can be used in case that the contract is split into several files. These files can be passed in a
   * Map that has the reference as key and the path to the file as value.
   * @param vertx The related Vert.x instance.
   * @param unresolvedContract The unresolved contract.
   * @param additionalContractFiles The additional contract files
   * @return A succeeded  holding an {@link io.vertx.reactivex.openapi.contract.OpenAPIContract} instance, otherwise a failed .
   */
  public static io.reactivex.Single<io.vertx.reactivex.openapi.contract.OpenAPIContract> rxFrom(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject unresolvedContract, java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> additionalContractFiles) { 
    return AsyncResultSingle.toSingle($handler -> {
      from(vertx, unresolvedContract, additionalContractFiles).onComplete($handler);
    });
  }

  /**
   * Access to an operation defined in the contract with <code>operationId</code>.
   * @param operationId the id of the operation.
   * @return the requested operation.
   */
  public io.vertx.reactivex.openapi.contract.Operation operation(java.lang.String operationId) { 
    io.vertx.reactivex.openapi.contract.Operation ret = io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)delegate.operation(operationId));
    return ret;
  }

  /**
   * @return all operations defined in the contract.
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Operation> operations() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Operation> ret = delegate.operations().stream().map(elt -> io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return all {@link io.vertx.reactivex.openapi.contract.Path Paths} defined in the OpenAPI contract.
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Path> getPaths() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Path> ret = delegate.getPaths().stream().map(elt -> io.vertx.reactivex.openapi.contract.Path.newInstance((io.vertx.openapi.contract.Path)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return the resolved OpenAPI contract as .
   */
  public io.vertx.core.json.JsonObject getRawContract() { 
    io.vertx.core.json.JsonObject ret = delegate.getRawContract();
    return ret;
  }

  /**
   * @return the OpenAPI version of the contract.
   */
  public io.vertx.openapi.contract.OpenAPIVersion getVersion() { 
    io.vertx.openapi.contract.OpenAPIVersion ret = delegate.getVersion();
    return ret;
  }

  /**
   * @return the  to validate against.
   */
  public io.vertx.reactivex.json.schema.SchemaRepository getSchemaRepository() { 
    io.vertx.reactivex.json.schema.SchemaRepository ret = io.vertx.reactivex.json.schema.SchemaRepository.newInstance((io.vertx.json.schema.SchemaRepository)delegate.getSchemaRepository());
    return ret;
  }

  /**
   * @return the servers of the contract.
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Server> getServers() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Server> ret = delegate.getServers().stream().map(elt -> io.vertx.reactivex.openapi.contract.Server.newInstance((io.vertx.openapi.contract.Server)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Finds the related {@link io.vertx.reactivex.openapi.contract.Path} object based on the passed url path.
   * @param urlPath The path of the request.
   * @return the found {@link io.vertx.reactivex.openapi.contract.Path} object, or null if the passed path doesn't match any {@link io.vertx.reactivex.openapi.contract.Path} object.
   */
  public io.vertx.reactivex.openapi.contract.Path findPath(java.lang.String urlPath) { 
    io.vertx.reactivex.openapi.contract.Path ret = io.vertx.reactivex.openapi.contract.Path.newInstance((io.vertx.openapi.contract.Path)delegate.findPath(urlPath));
    return ret;
  }

  /**
   * Finds the related {@link io.vertx.reactivex.openapi.contract.Operation} object based on the passed url path and method.
   * @param urlPath The path of the request.
   * @param method The method of the request.
   * @return the found {@link io.vertx.reactivex.openapi.contract.Operation} object, or null if the passed path and method doesn't match any {@link io.vertx.reactivex.openapi.contract.Operation} object.
   */
  public io.vertx.reactivex.openapi.contract.Operation findOperation(java.lang.String urlPath, io.vertx.core.http.HttpMethod method) { 
    io.vertx.reactivex.openapi.contract.Operation ret = io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)delegate.findOperation(urlPath, method));
    return ret;
  }

  /**
   * Returns the applicable list of global security requirements (scopes) or empty list.
   * @return The related security requirement.
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.SecurityRequirement> getSecurityRequirements() { 
    java.util.List<io.vertx.reactivex.openapi.contract.SecurityRequirement> ret = delegate.getSecurityRequirements().stream().map(elt -> io.vertx.reactivex.openapi.contract.SecurityRequirement.newInstance((io.vertx.openapi.contract.SecurityRequirement)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Gets the related {@link io.vertx.reactivex.openapi.contract.SecurityScheme} object based on the passed name.
   * @param name The name of the security scheme.
   * @return the found {@link io.vertx.reactivex.openapi.contract.SecurityScheme} object, or null if the passed path and method doesn't match any {@link io.vertx.reactivex.openapi.contract.Operation} object.
   */
  public io.vertx.reactivex.openapi.contract.SecurityScheme securityScheme(java.lang.String name) { 
    io.vertx.reactivex.openapi.contract.SecurityScheme ret = io.vertx.reactivex.openapi.contract.SecurityScheme.newInstance((io.vertx.openapi.contract.SecurityScheme)delegate.securityScheme(name));
    return ret;
  }

  public static OpenAPIContract newInstance(io.vertx.openapi.contract.OpenAPIContract arg) {
    return arg != null ? new OpenAPIContract(arg) : null;
  }

}
