/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface represents the most important attributes of an OpenAPI Operation.
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#media-type-Object">Operation V3.1</a>
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.3.md#media-type-Object">Operation V3.0</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.MediaType original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.MediaType.class)
public class MediaType implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MediaType that = (MediaType) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MediaType> __TYPE_ARG = new TypeArg<>(    obj -> new MediaType((io.vertx.openapi.contract.MediaType) obj),
    MediaType::getDelegate
  );

  private final io.vertx.openapi.contract.MediaType delegate;
  
  public MediaType(io.vertx.openapi.contract.MediaType delegate) {
    this.delegate = delegate;
  }

  public MediaType(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.MediaType)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.MediaType getDelegate() {
    return delegate;
  }

  public static boolean isMediaTypeSupported(java.lang.String type) { 
    boolean ret = io.vertx.openapi.contract.MediaType.isMediaTypeSupported(type);
    return ret;
  }

  /**
   * @return the schema defining the content of the request.
   */
  public io.vertx.reactivex.json.schema.JsonSchema getSchema() { 
    io.vertx.reactivex.json.schema.JsonSchema ret = io.vertx.reactivex.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)delegate.getSchema());
    return ret;
  }

  /**
   * @return the identifier like <i>application/json</i>
   */
  public java.lang.String getIdentifier() { 
    java.lang.String ret = delegate.getIdentifier();
    return ret;
  }

  public static final java.lang.String APPLICATION_HAL_JSON = io.vertx.openapi.contract.MediaType.APPLICATION_HAL_JSON;
  public static final java.lang.String APPLICATION_JSON = io.vertx.openapi.contract.MediaType.APPLICATION_JSON;
  public static final java.lang.String APPLICATION_JSON_UTF8 = io.vertx.openapi.contract.MediaType.APPLICATION_JSON_UTF8;
  public static final java.lang.String MULTIPART_FORM_DATA = io.vertx.openapi.contract.MediaType.MULTIPART_FORM_DATA;
  public static final java.util.List<java.lang.String> SUPPORTED_MEDIA_TYPES = io.vertx.openapi.contract.MediaType.SUPPORTED_MEDIA_TYPES;
  public static MediaType newInstance(io.vertx.openapi.contract.MediaType arg) {
    return arg != null ? new MediaType(arg) : null;
  }

}
