/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.jdbcclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * JDBCPool is the interface that allows using the Sql Client API with plain JDBC.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.jdbcclient.JDBCPool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.jdbcclient.JDBCPool.class)
public class JDBCPool extends io.vertx.reactivex.sqlclient.Pool implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCPool that = (JDBCPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCPool> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCPool((io.vertx.jdbcclient.JDBCPool) obj),
    JDBCPool::getDelegate
  );

  private final io.vertx.jdbcclient.JDBCPool delegate;
  
  public JDBCPool(io.vertx.jdbcclient.JDBCPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCPool(Object delegate) {
    super((io.vertx.jdbcclient.JDBCPool)delegate);
    this.delegate = (io.vertx.jdbcclient.JDBCPool)delegate;
  }

  @Override 
  public io.vertx.jdbcclient.JDBCPool getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC pool which maintains its own data source and the {@link io.vertx.reactivex.jdbcclient.JDBCPool #DEFAULT_DATA_SOURCE_PROVIDER default data source provider}.
   * @param vertx the Vert.x instance
   * @param connectOptions the options to configure the connection
   * @param poolOptions the connection pool options
   * @return the client
   */
  public static io.vertx.reactivex.jdbcclient.JDBCPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.jdbcclient.JDBCConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.jdbcclient.JDBCPool ret = io.vertx.reactivex.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * Create a JDBC pool which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the options to configure the client using the same format as {@link io.vertx.reactivex.ext.jdbc.JDBCClient}
   * @return the client
   */
  @Deprecated()
  public static io.vertx.reactivex.jdbcclient.JDBCPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.reactivex.jdbcclient.JDBCPool ret = io.vertx.reactivex.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a JDBC pool which maintains its own data source, with the specified provider.
   * <p>
   * The datasource will be named after , even though the Javadoc in this class indicates that the name is only used when the  is shared.
   * @param vertx the Vert.x instance
   * @param connectOptions the options to configure the connection
   * @param poolOptions the connection pool options
   * @param provider the data source provider
   * @return the client
   */
  public static io.vertx.reactivex.jdbcclient.JDBCPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.jdbcclient.JDBCConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions, io.vertx.ext.jdbc.spi.DataSourceProvider provider) { 
    io.vertx.reactivex.jdbcclient.JDBCPool ret = io.vertx.reactivex.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), connectOptions, poolOptions, provider));
    return ret;
  }

  /**
   * Create a JDBC pool which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param dataSourceProvider the options to configure the client using the same format as {@link io.vertx.reactivex.ext.jdbc.JDBCClient}
   * @return the client
   */
  public static io.vertx.reactivex.jdbcclient.JDBCPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.jdbc.spi.DataSourceProvider dataSourceProvider) { 
    io.vertx.reactivex.jdbcclient.JDBCPool ret = io.vertx.reactivex.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), dataSourceProvider));
    return ret;
  }

  /**
   * Create a JDBC pool using a pre-initialized data source.
   * @param vertx the Vert.x instance
   * @param dataSource a pre-initialized data source
   * @return the client
   */
  public static io.vertx.reactivex.jdbcclient.JDBCPool pool(io.vertx.reactivex.core.Vertx vertx, javax.sql.DataSource dataSource) { 
    io.vertx.reactivex.jdbcclient.JDBCPool ret = io.vertx.reactivex.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), dataSource));
    return ret;
  }

  /**
   * Create a JDBC pool using a pre-initialized data source. The config expects that at least the following properties
   * are set:
   *
   * <ul>
   *   <li><code>url</code> - the connection string</li>
   *   <li><code>user</code> - the connection user name</li>
   *   <li><code>database</code> - the database name</li>
   *   <li><code>maxPoolSize</code> - the max allowed number of connections in the pool</li>
   * </ul>
   * @param vertx the Vert.x instance
   * @param dataSource a pre-initialized data source
   * @param config the pool configuration
   * @return the client
   */
  @Deprecated()
  public static io.vertx.reactivex.jdbcclient.JDBCPool pool(io.vertx.reactivex.core.Vertx vertx, javax.sql.DataSource dataSource, io.vertx.core.json.JsonObject config) { 
    io.vertx.reactivex.jdbcclient.JDBCPool ret = io.vertx.reactivex.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), dataSource, config));
    return ret;
  }

  /**
   * The default data source provider for this pool,
   * loaded from JVM system properties with the  key.
   *
   * The value can be one of:
   * <ul>
   *   <li>C3P0: </li>
   *   <li>Hikari: </li>
   *   <li>Agroal: </li>
   * </ul>
   *
   * When there is no JVM wide defined provider or the value is incorrect,  is returned.
   */
  public static final java.util.function.Supplier<io.vertx.ext.jdbc.spi.DataSourceProvider> DEFAULT_DATA_SOURCE_PROVIDER = io.vertx.jdbcclient.JDBCPool.DEFAULT_DATA_SOURCE_PROVIDER;
  /**
   * The property to be used to retrieve the generated keys
   */
  public static final io.vertx.reactivex.sqlclient.PropertyKind<io.vertx.reactivex.sqlclient.Row> GENERATED_KEYS = io.vertx.reactivex.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.jdbcclient.JDBCPool.GENERATED_KEYS, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o0 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o0), o0 -> o0.getDelegate()));
  /**
   * The property to be used to retrieve the output of the callable statement
   */
  public static final io.vertx.reactivex.sqlclient.PropertyKind<java.lang.Boolean> OUTPUT = io.vertx.reactivex.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.jdbcclient.JDBCPool.OUTPUT, TypeArg.unknown());
  public static JDBCPool newInstance(io.vertx.jdbcclient.JDBCPool arg) {
    return arg != null ? new JDBCPool(arg) : null;
  }

}
