/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.openapi.router;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface to build a Vert.x Web  from an OpenAPI 3 contract.
 * <p></p>
 * The router is mounting its handlers in the following order:
 * <ol>
 *   <li>RootHandler</li> in the order the root handlers were added to the RouterBuilder.
 *   <li>ValidationHandler</li> This handler is implementing the marker interface
 *   {@link io.vertx.reactivex.ext.web.handler.InputTrustHandler}. Because of this, all handlers of type <i>PLATFORM</i>,
 *   <i>SECURITY_POLICY</i>, <i>BODY</i> and <i>AUTHENTICATION</i> must be mounted as root handlers if required.
 *   <li>UserHandler</li> The custom user handlers defined in the {@link io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute} in the same order as they are
 *   added to the route.
 *   <li>FailureHandler</li> The failure handlers defined in the {@link io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute} in the same order as they are
 *   added to the route.
 * </ol>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.openapi.router.RouterBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.openapi.router.RouterBuilder.class)
public class RouterBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouterBuilder that = (RouterBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RouterBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new RouterBuilder((io.vertx.ext.web.openapi.router.RouterBuilder) obj),
    RouterBuilder::getDelegate
  );

  private final io.vertx.ext.web.openapi.router.RouterBuilder delegate;
  
  public RouterBuilder(io.vertx.ext.web.openapi.router.RouterBuilder delegate) {
    this.delegate = delegate;
  }

  public RouterBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.router.RouterBuilder)delegate;
  }

  @Override 
  public io.vertx.ext.web.openapi.router.RouterBuilder getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute>(o1 -> io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute.newInstance((io.vertx.ext.web.openapi.router.OpenAPIRoute)o1), o1 -> o1.getDelegate());

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.openapi.router.RouterBuilder}. Like {@link io.vertx.reactivex.ext.web.openapi.router.RouterBuilder#create} but uses a default
   * implementation for the <i>extractor</i>.
   * @param vertx the related Vert.x instance
   * @param contract the contract that describes the endpoint
   * @return an instance of {@link io.vertx.reactivex.ext.web.openapi.router.RouterBuilder}
   */
  public static io.vertx.reactivex.ext.web.openapi.router.RouterBuilder create(io.vertx.reactivex.core.Vertx vertx, io.vertx.reactivex.openapi.contract.OpenAPIContract contract) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)io.vertx.ext.web.openapi.router.RouterBuilder.create(vertx.getDelegate(), contract.getDelegate()));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.openapi.router.RouterBuilder}.
   * @param vertx the related Vert.x instance
   * @param contract the contract that describes the endpoint
   * @param extractor the extractor is used to extract and transform the parameters and body of the related request in a format that can be validated by the {@link io.vertx.reactivex.openapi.validation.RequestValidator}.
   * @return an instance of {@link io.vertx.reactivex.ext.web.openapi.router.RouterBuilder}
   */
  public static io.vertx.reactivex.ext.web.openapi.router.RouterBuilder create(io.vertx.reactivex.core.Vertx vertx, io.vertx.reactivex.openapi.contract.OpenAPIContract contract, io.vertx.reactivex.ext.web.openapi.router.RequestExtractor extractor) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)io.vertx.ext.web.openapi.router.RouterBuilder.create(vertx.getDelegate(), contract.getDelegate(), extractor.getDelegate()));
    return ret;
  }

  /**
   * Access to a route defined in the contract with <code>operationId</code>
   * @param operationId the id of the operation
   * @return the requested route, or null if the passed operationId doesn't exist.
   */
  public io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute getRoute(java.lang.String operationId) { 
    io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute ret = io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute.newInstance((io.vertx.ext.web.openapi.router.OpenAPIRoute)delegate.getRoute(operationId));
    return ret;
  }

  /**
   * @return all routes defined in the contract
   */
  public java.util.List<io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute> getRoutes() { 
    java.util.List<io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute> ret = delegate.getRoutes().stream().map(elt -> io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute.newInstance((io.vertx.ext.web.openapi.router.OpenAPIRoute)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Add global handler to be applied prior to  being generated. <br/>
   * @param rootHandler the root handler to add
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder rootHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> rootHandler) { 
    delegate.rootHandler(io.vertx.lang.reactivex.Helper.convertHandler(rootHandler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Construct a new router based on the related OpenAPI contract.
   * @return a Router based on the related OpenAPI contract.
   */
  public io.vertx.reactivex.ext.web.Router createRouter() { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.createRouter());
    return ret;
  }

  public static final java.lang.String KEY_META_DATA_OPERATION = io.vertx.ext.web.openapi.router.RouterBuilder.KEY_META_DATA_OPERATION;
  public static final java.lang.String KEY_META_DATA_VALIDATED_REQUEST = io.vertx.ext.web.openapi.router.RouterBuilder.KEY_META_DATA_VALIDATED_REQUEST;
  public static RouterBuilder newInstance(io.vertx.ext.web.openapi.router.RouterBuilder arg) {
    return arg != null ? new RouterBuilder(arg) : null;
  }

}
