/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.cassandra.CassandraRowStream;
import io.vertx.reactivex.cassandra.ResultSet;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient
implements RxDelegate {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg(obj -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    public CassandraClient(Object delegate) {
        this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public static CassandraClient create(io.vertx.reactivex.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient create(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, String clientName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, String clientName, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName, (CassandraClientOptions)options));
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public CassandraClient execute(String query, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(query, Helper.convertHandler(resultHandler, ar -> ar.map(event -> ResultSet.newInstance(event))));
        return this;
    }

    public CassandraClient execute(String query) {
        return this.execute(query, (Handler<AsyncResult<ResultSet>>)((Handler)ar -> {}));
    }

    public Single<ResultSet> rxExecute(String query) {
        return AsyncResultSingle.toSingle($handler -> this.execute(query, (Handler<AsyncResult<ResultSet>>)$handler));
    }

    public CassandraClient queryStream(String sql, Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(sql, Helper.convertHandler(rowStreamHandler, ar -> ar.map(event -> CassandraRowStream.newInstance(event))));
        return this;
    }

    public CassandraClient queryStream(String sql) {
        return this.queryStream(sql, (Handler<AsyncResult<CassandraRowStream>>)((Handler)ar -> {}));
    }

    public Single<CassandraRowStream> rxQueryStream(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.queryStream(sql, (Handler<AsyncResult<CassandraRowStream>>)$handler));
    }

    public CassandraClient close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
        return this;
    }

    public CassandraClient close() {
        return this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public CassandraClient executeWithFullFetch(String query, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(query, resultHandler);
        return this;
    }

    public CassandraClient executeWithFullFetch(String query) {
        return this.executeWithFullFetch(query, (Handler<AsyncResult<List<Row>>>)((Handler)ar -> {}));
    }

    public Single<List<Row>> rxExecuteWithFullFetch(String query) {
        return AsyncResultSingle.toSingle($handler -> this.executeWithFullFetch(query, (Handler<AsyncResult<List<Row>>>)$handler));
    }

    public CassandraClient executeWithFullFetch(Statement statement, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(statement, resultHandler);
        return this;
    }

    public CassandraClient executeWithFullFetch(Statement statement) {
        return this.executeWithFullFetch(statement, (Handler<AsyncResult<List<Row>>>)((Handler)ar -> {}));
    }

    public Single<List<Row>> rxExecuteWithFullFetch(Statement statement) {
        return AsyncResultSingle.toSingle($handler -> this.executeWithFullFetch(statement, (Handler<AsyncResult<List<Row>>>)$handler));
    }

    public CassandraClient execute(Statement statement, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(statement, Helper.convertHandler(resultHandler, ar -> ar.map(event -> ResultSet.newInstance(event))));
        return this;
    }

    public CassandraClient execute(Statement statement) {
        return this.execute(statement, (Handler<AsyncResult<ResultSet>>)((Handler)ar -> {}));
    }

    public Single<ResultSet> rxExecute(Statement statement) {
        return AsyncResultSingle.toSingle($handler -> this.execute(statement, (Handler<AsyncResult<ResultSet>>)$handler));
    }

    public CassandraClient prepare(String query, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        this.delegate.prepare(query, resultHandler);
        return this;
    }

    public CassandraClient prepare(String query) {
        return this.prepare(query, (Handler<AsyncResult<PreparedStatement>>)((Handler)ar -> {}));
    }

    public Single<PreparedStatement> rxPrepare(String query) {
        return AsyncResultSingle.toSingle($handler -> this.prepare(query, (Handler<AsyncResult<PreparedStatement>>)$handler));
    }

    public CassandraClient prepare(SimpleStatement statement, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        this.delegate.prepare(statement, resultHandler);
        return this;
    }

    public CassandraClient prepare(SimpleStatement statement) {
        return this.prepare(statement, (Handler<AsyncResult<PreparedStatement>>)((Handler)ar -> {}));
    }

    public Single<PreparedStatement> rxPrepare(SimpleStatement statement) {
        return AsyncResultSingle.toSingle($handler -> this.prepare(statement, (Handler<AsyncResult<PreparedStatement>>)$handler));
    }

    public CassandraClient queryStream(Statement statement, Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(statement, Helper.convertHandler(rowStreamHandler, ar -> ar.map(event -> CassandraRowStream.newInstance(event))));
        return this;
    }

    public CassandraClient queryStream(Statement statement) {
        return this.queryStream(statement, (Handler<AsyncResult<CassandraRowStream>>)((Handler)ar -> {}));
    }

    public Single<CassandraRowStream> rxQueryStream(Statement statement) {
        return AsyncResultSingle.toSingle($handler -> this.queryStream(statement, (Handler<AsyncResult<CassandraRowStream>>)$handler));
    }

    public void metadata(Handler<AsyncResult<Metadata>> handler) {
        this.delegate.metadata(handler);
    }

    public void metadata() {
        this.metadata((Handler<AsyncResult<Metadata>>)((Handler)ar -> {}));
    }

    public Single<Metadata> rxMetadata() {
        return AsyncResultSingle.toSingle($handler -> this.metadata((Handler<AsyncResult<Metadata>>)$handler));
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

