/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.eventbus;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.eventbus.DeliveryContext;
import io.vertx.reactivex.core.eventbus.Message;
import io.vertx.reactivex.core.eventbus.MessageConsumer;
import io.vertx.reactivex.core.eventbus.MessageProducer;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.core.eventbus.EventBus.class)
public class EventBus
implements RxDelegate,
Measured {
    public static final TypeArg<EventBus> __TYPE_ARG = new TypeArg(obj -> new EventBus((io.vertx.core.eventbus.EventBus)obj), EventBus::getDelegate);
    private final io.vertx.core.eventbus.EventBus delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBus that = (EventBus)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public EventBus(io.vertx.core.eventbus.EventBus delegate) {
        this.delegate = delegate;
    }

    public EventBus(Object delegate) {
        this.delegate = (io.vertx.core.eventbus.EventBus)delegate;
    }

    public io.vertx.core.eventbus.EventBus getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public EventBus send(String address, Object message) {
        this.delegate.send(address, message);
        return this;
    }

    public EventBus send(String address, Object message, DeliveryOptions options) {
        this.delegate.send(address, message, options);
        return this;
    }

    public <T> EventBus request(String address, Object message, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.request(address, message, Helper.convertHandler(replyHandler, ar -> ar.map(event -> Message.newInstance(event, TypeArg.unknown()))));
        return this;
    }

    public <T> EventBus request(String address, Object message) {
        return this.request(address, message, ar -> {});
    }

    public <T> Single<Message<T>> rxRequest(String address, Object message) {
        return AsyncResultSingle.toSingle($handler -> this.request(address, message, (Handler)$handler));
    }

    public <T> EventBus request(String address, Object message, DeliveryOptions options, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.request(address, message, options, Helper.convertHandler(replyHandler, ar -> ar.map(event -> Message.newInstance(event, TypeArg.unknown()))));
        return this;
    }

    public <T> EventBus request(String address, Object message, DeliveryOptions options) {
        return this.request(address, message, options, ar -> {});
    }

    public <T> Single<Message<T>> rxRequest(String address, Object message, DeliveryOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.request(address, message, options, (Handler)$handler));
    }

    public EventBus publish(String address, Object message) {
        this.delegate.publish(address, message);
        return this;
    }

    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.delegate.publish(address, message, options);
        return this;
    }

    public <T> MessageConsumer<T> consumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address, Helper.convertHandler(handler, event -> Message.newInstance(event, TypeArg.unknown()))), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address, Helper.convertHandler(handler, event -> Message.newInstance(event, TypeArg.unknown()))), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address, options), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address, options), TypeArg.unknown());
        return ret;
    }

    public EventBus codecSelector(Function<Object, String> selector) {
        this.delegate.codecSelector(selector);
        return this;
    }

    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addOutboundInterceptor(Helper.convertHandler(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeOutboundInterceptor(Helper.convertHandler(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addInboundInterceptor(Helper.convertHandler(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeInboundInterceptor(Helper.convertHandler(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public EventBus clusterSerializableChecker(Function<String, Boolean> classNamePredicate) {
        this.delegate.clusterSerializableChecker(classNamePredicate);
        return this;
    }

    public EventBus serializableChecker(Function<String, Boolean> classNamePredicate) {
        this.delegate.serializableChecker(classNamePredicate);
        return this;
    }

    public EventBus registerCodec(MessageCodec codec) {
        this.delegate.registerCodec(codec);
        return this;
    }

    public EventBus unregisterCodec(String name) {
        this.delegate.unregisterCodec(name);
        return this;
    }

    public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
        return arg != null ? new EventBus(arg) : null;
    }
}

