/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.rabbitmq.RabbitMQConsumer;
import io.vertx.reactivex.rabbitmq.RabbitMQMessage;
import java.util.Map;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.reactivex.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.reactivex.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicAck(long deliveryTag, boolean multiple) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<Void>>)$handler));
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<Void>>)$handler));
    }

    public void basicGet(String queue, boolean autoAck, final Handler<AsyncResult<RabbitMQMessage>> resultHandler) {
        this.delegate.basicGet(queue, autoAck, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQMessage>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQMessage> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void basicGet(String queue, boolean autoAck) {
        this.basicGet(queue, autoAck, (Handler<AsyncResult<RabbitMQMessage>>)((Handler)ar -> {}));
    }

    public Single<RabbitMQMessage> rxBasicGet(String queue, boolean autoAck) {
        return AsyncResultSingle.toSingle($handler -> this.basicGet(queue, autoAck, (Handler<AsyncResult<RabbitMQMessage>>)$handler));
    }

    public void basicConsumer(String queue, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void basicConsumer(String queue) {
        this.basicConsumer(queue, (Handler<AsyncResult<RabbitMQConsumer>>)((Handler)ar -> {}));
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue) {
        return AsyncResultSingle.toSingle($handler -> this.basicConsumer(queue, (Handler<AsyncResult<RabbitMQConsumer>>)$handler));
    }

    public void basicConsumer(String queue, QueueOptions options, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, options, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void basicConsumer(String queue, QueueOptions options) {
        this.basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)((Handler)ar -> {}));
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue, QueueOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)$handler));
    }

    public void basicPublish(String exchange, String routingKey, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler);
    }

    public void basicPublish(String exchange, String routingKey, Buffer body) {
        this.basicPublish(exchange, routingKey, body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicPublish(String exchange, String routingKey, Buffer body) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicPublish(exchange, routingKey, body, (Handler<AsyncResult<Void>>)$handler));
    }

    public void addConfirmListener(int maxQueueSize, final Handler<AsyncResult<io.vertx.reactivex.core.streams.ReadStream<RabbitMQConfirmation>>> resultHandler) {
        this.delegate.addConfirmListener(maxQueueSize, (Handler)new Handler<AsyncResult<ReadStream<RabbitMQConfirmation>>>(){

            public void handle(AsyncResult<ReadStream<RabbitMQConfirmation>> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture(io.vertx.reactivex.core.streams.ReadStream.newInstance((ReadStream)ar.result(), TypeArg.unknown())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void addConfirmListener(int maxQueueSize) {
        this.addConfirmListener(maxQueueSize, (Handler<AsyncResult<io.vertx.reactivex.core.streams.ReadStream<RabbitMQConfirmation>>>)((Handler)ar -> {}));
    }

    public Single<io.vertx.reactivex.core.streams.ReadStream<RabbitMQConfirmation>> rxAddConfirmListener(int maxQueueSize) {
        return AsyncResultSingle.toSingle($handler -> this.addConfirmListener(maxQueueSize, (Handler<AsyncResult<io.vertx.reactivex.core.streams.ReadStream<RabbitMQConfirmation>>>)$handler));
    }

    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.confirmSelect(resultHandler);
    }

    public void confirmSelect() {
        this.confirmSelect((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxConfirmSelect() {
        return AsyncResultCompletable.toCompletable($handler -> this.confirmSelect((Handler<AsyncResult<Void>>)$handler));
    }

    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(resultHandler);
    }

    public void waitForConfirms() {
        this.waitForConfirms((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxWaitForConfirms() {
        return AsyncResultCompletable.toCompletable($handler -> this.waitForConfirms((Handler<AsyncResult<Void>>)$handler));
    }

    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(timeout, resultHandler);
    }

    public void waitForConfirms(long timeout) {
        this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxWaitForConfirms(long timeout) {
        return AsyncResultCompletable.toCompletable($handler -> this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)$handler));
    }

    public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, resultHandler);
    }

    public void basicQos(int prefetchCount) {
        this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicQos(int prefetchCount) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)$handler));
    }

    public void basicQos(int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, global, resultHandler);
    }

    public void basicQos(int prefetchCount, boolean global) {
        this.basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicQos(int prefetchCount, boolean global) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)$handler));
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
        this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicQos(int prefetchSize, int prefetchCount, boolean global) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, resultHandler);
    }

    public void exchangeDelete(String exchange) {
        this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeDelete(String exchange) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, resultHandler);
    }

    public void exchangeBind(String destination, String source, String routingKey) {
        this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler);
    }

    public void exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeBind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeBind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
    }

    public void exchangeUnbind(String destination, String source, String routingKey) {
        this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)$handler));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler);
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeUnbind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeUnbind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)$handler));
    }

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    public void queueDeclareAuto() {
        this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return AsyncResultSingle.toSingle($handler -> this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)$handler));
    }

    public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, resultHandler);
    }

    public void queueBind(String queue, String exchange, String routingKey) {
        this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)$handler));
    }

    public void queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler);
    }

    public void queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueBind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueBind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)$handler));
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue, exchange, routingKey, resultHandler);
    }

    public void queueUnbind(String queue, String exchange, String routingKey) {
        this.queueUnbind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxQueueUnbind(String queue, String exchange, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueUnbind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)$handler));
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler);
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueUnbind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxQueueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueUnbind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)$handler));
    }

    public void messageCount(String queue, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.messageCount(queue, resultHandler);
    }

    public void messageCount(String queue) {
        this.messageCount(queue, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxMessageCount(String queue) {
        return AsyncResultSingle.toSingle($handler -> this.messageCount(queue, (Handler<AsyncResult<Long>>)$handler));
    }

    public void start(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(resultHandler);
    }

    public void start() {
        this.start((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxStart() {
        return AsyncResultCompletable.toCompletable($handler -> this.start((Handler<AsyncResult<Void>>)$handler));
    }

    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(resultHandler);
    }

    public void stop() {
        this.stop((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxStop() {
        return AsyncResultCompletable.toCompletable($handler -> this.stop((Handler<AsyncResult<Void>>)$handler));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public void basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, properties, body.getDelegate(), resultHandler);
    }

    public void basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        this.basicPublish(exchange, routingKey, properties, body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicPublish(exchange, routingKey, properties, body, (Handler<AsyncResult<Void>>)$handler));
    }

    public void basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body.getDelegate(), deliveryTagHandler, resultHandler);
    }

    public void basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxBasicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler, (Handler<AsyncResult<Void>>)$handler));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return AsyncResultSingle.toSingle($handler -> this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)$handler));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return AsyncResultSingle.toSingle($handler -> this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)$handler));
    }

    public void queueDelete(String queue, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.delegate.queueDelete(queue, resultHandler);
    }

    public void queueDelete(String queue) {
        this.queueDelete(queue, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDelete(String queue) {
        return AsyncResultSingle.toSingle($handler -> this.queueDelete(queue, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)$handler));
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return AsyncResultSingle.toSingle($handler -> this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)$handler));
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

