/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.SingleHelper;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.PreparedQuery;
import io.vertx.reactivex.sqlclient.Query;
import io.vertx.reactivex.sqlclient.Row;
import io.vertx.reactivex.sqlclient.RowSet;
import io.vertx.reactivex.sqlclient.SqlClient;
import io.vertx.reactivex.sqlclient.SqlConnection;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;

@RxGen(value=io.vertx.sqlclient.Pool.class)
public class Pool
extends SqlClient {
    public static final TypeArg<Pool> __TYPE_ARG = new TypeArg(obj -> new Pool((io.vertx.sqlclient.Pool)obj), Pool::getDelegate);
    private final io.vertx.sqlclient.Pool delegate;
    private static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    private static final TypeArg<RowSet<Row>> TYPE_ARG_1 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Pool(io.vertx.sqlclient.Pool delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public Pool(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.Pool)delegate));
        this.delegate = (io.vertx.sqlclient.Pool)delegate;
    }

    public io.vertx.sqlclient.Pool getDelegate() {
        return this.delegate;
    }

    public static Pool pool(SqlConnectOptions connectOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions));
        return ret;
    }

    public static Pool pool(SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public static Pool pool(io.vertx.reactivex.core.Vertx vertx, SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((Vertx)vertx.getDelegate(), (SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public void getConnection(final Handler<AsyncResult<SqlConnection>> handler) {
        this.delegate.getConnection((Handler)new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void getConnection() {
        this.getConnection((Handler<AsyncResult<SqlConnection>>)((Handler)ar -> {}));
    }

    public Single<SqlConnection> rxGetConnection() {
        return AsyncResultSingle.toSingle($handler -> this.getConnection((Handler<AsyncResult<SqlConnection>>)$handler));
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        Query<RowSet<Row>> ret = Query.newInstance(this.delegate.query(sql), TYPE_ARG_0);
        return ret;
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.preparedQuery(sql), TYPE_ARG_1);
        return ret;
    }

    public <T> void withTransaction(final java.util.function.Function<SqlConnection, Future<T>> function, Handler<AsyncResult<T>> handler) {
        this.delegate.withTransaction(new java.util.function.Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                Future ret = (Future)function.apply(SqlConnection.newInstance(arg));
                return ret;
            }
        }, handler);
    }

    public <T> void withTransaction(java.util.function.Function<SqlConnection, Future<T>> function) {
        this.withTransaction(function, ar -> {});
    }

    public <T> Single<T> rxWithTransaction(java.util.function.Function<SqlConnection, Future<T>> function) {
        return AsyncResultSingle.toSingle($handler -> this.withTransaction(function, (Handler)$handler));
    }

    public <T> void withTransaction(final Function<SqlConnection, Single<T>> function, Handler<AsyncResult<T>> handler) {
        this.delegate.withTransaction(new java.util.function.Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                Single ret;
                try {
                    ret = (Single)function.apply((Object)SqlConnection.newInstance(arg));
                }
                catch (Exception e) {
                    return Future.failedFuture((Throwable)e);
                }
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }, handler);
    }

    public <T> void withTransaction(Function<SqlConnection, Single<T>> function) {
        this.withTransaction(function, ar -> {});
    }

    public <T> Single<T> rxWithTransaction(Function<SqlConnection, Single<T>> function) {
        return AsyncResultSingle.toSingle($handler -> this.withTransaction(function, (Handler)$handler));
    }

    public <T> void withConnection(final java.util.function.Function<SqlConnection, Future<T>> function, Handler<AsyncResult<T>> handler) {
        this.delegate.withConnection(new java.util.function.Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                Future ret = (Future)function.apply(SqlConnection.newInstance(arg));
                return ret;
            }
        }, handler);
    }

    public <T> void withConnection(java.util.function.Function<SqlConnection, Future<T>> function) {
        this.withConnection(function, ar -> {});
    }

    public <T> Single<T> rxWithConnection(java.util.function.Function<SqlConnection, Future<T>> function) {
        return AsyncResultSingle.toSingle($handler -> this.withConnection(function, (Handler)$handler));
    }

    public <T> void withConnection(final Function<SqlConnection, Single<T>> function, Handler<AsyncResult<T>> handler) {
        this.delegate.withConnection(new java.util.function.Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                Single ret;
                try {
                    ret = (Single)function.apply((Object)SqlConnection.newInstance(arg));
                }
                catch (Exception e) {
                    return Future.failedFuture((Throwable)e);
                }
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }, handler);
    }

    public <T> void withConnection(Function<SqlConnection, Single<T>> function) {
        this.withConnection(function, ar -> {});
    }

    public <T> Single<T> rxWithConnection(Function<SqlConnection, Single<T>> function) {
        return AsyncResultSingle.toSingle($handler -> this.withConnection(function, (Handler)$handler));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
        return arg != null ? new Pool(arg) : null;
    }
}

