/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.eventbus;

import io.reactivex.Completable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;

@RxGen(value=io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T>
implements io.vertx.reactivex.core.streams.WriteStream<T> {
    public static final TypeArg<MessageProducer> __TYPE_ARG = new TypeArg(obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer)obj), MessageProducer::getDelegate);
    private final io.vertx.core.eventbus.MessageProducer<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private WriteStreamObserver<T> observer;
    private WriteStreamSubscriber<T> subscriber;
    public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = 1000;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageProducer that = (MessageProducer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.core.eventbus.MessageProducer getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamObserver<T> toObserver() {
        if (this.observer == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<T> toSubscriber() {
        if (this.subscriber == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(T data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(this.__typeArg_0.unwrap(data), handler);
    }

    @Override
    public void write(T data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWrite(T data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public void end(T data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(this.__typeArg_0.unwrap(data), handler);
    }

    @Override
    public void end(T data) {
        this.end(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd(T data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MessageProducer<T> setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public MessageProducer<T> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.delegate.deliveryOptions(options);
        return this;
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end((Handler<AsyncResult<Void>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
        return arg != null ? new MessageProducer<T>(arg) : null;
    }

    public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
    }
}

