/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.rabbitmq;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.rabbitmq.RabbitMQMessage;
import java.util.function.Function;

@RxGen(value=io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer
implements ReadStream<RabbitMQMessage> {
    public static final TypeArg<RabbitMQConsumer> __TYPE_ARG = new TypeArg(obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer)obj), RabbitMQConsumer::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
    private Observable<RabbitMQMessage> observable;
    private Flowable<RabbitMQMessage> flowable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQConsumer that = (RabbitMQConsumer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
        this.delegate = delegate;
    }

    public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<RabbitMQMessage> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.rabbitmq.RabbitMQMessage, RabbitMQMessage> conv = RabbitMQMessage::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<RabbitMQMessage> toFlowable() {
        if (this.flowable == null) {
            Function<io.vertx.rabbitmq.RabbitMQMessage, RabbitMQMessage> conv = RabbitMQMessage::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public ReadStream<RabbitMQMessage> fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public RabbitMQConsumer exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public RabbitMQConsumer handler(final Handler<RabbitMQMessage> messageArrived) {
        this.delegate.handler((Handler)new Handler<io.vertx.rabbitmq.RabbitMQMessage>(){

            public void handle(io.vertx.rabbitmq.RabbitMQMessage event) {
                messageArrived.handle((Object)RabbitMQMessage.newInstance(event));
            }
        });
        return this;
    }

    public RabbitMQConsumer pause() {
        this.delegate.pause();
        return this;
    }

    public RabbitMQConsumer resume() {
        this.delegate.resume();
        return this;
    }

    public RabbitMQConsumer endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public String consumerTag() {
        String ret = this.delegate.consumerTag();
        return ret;
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void cancel(Handler<AsyncResult<Void>> cancelResult) {
        this.delegate.cancel(cancelResult);
    }

    public Completable rxCancel() {
        return AsyncResultCompletable.toCompletable(handler -> this.cancel((Handler<AsyncResult<Void>>)handler));
    }

    public boolean isPaused() {
        boolean ret = this.delegate.isPaused();
        return ret;
    }

    public static RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
        return arg != null ? new RabbitMQConsumer(arg) : null;
    }
}

