/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.impl;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncResultCompletable
extends Completable {
    private final Handler<Handler<AsyncResult<Void>>> method;

    public AsyncResultCompletable(Handler<Handler<AsyncResult<Void>>> method) {
        this.method = method;
    }

    protected void subscribeActual(CompletableObserver observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.method.handle(ar -> {
                        if (!disposed.getAndSet(true)) {
                            if (ar.succeeded()) {
                                try {
                                    observer.onComplete();
                                }
                                catch (Throwable throwable) {}
                            } else {
                                try {
                                    observer.onError(ar.cause());
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

