/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.datagram;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.datagram.DatagramPacket;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import java.util.function.Function;

@RxGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements ReadStream<DatagramPacket>,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg<DatagramSocket>(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    private Observable<DatagramPacket> observable;
    private Flowable<DatagramPacket> flowable;
    private SocketAddress cached_0;

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<DatagramPacket> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<DatagramPacket> toFlowable() {
        if (this.flowable == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public DatagramSocket send(Buffer packet, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(packet.getDelegate(), port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxSend(Buffer packet, int port, String host) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.send(packet, port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public WriteStream<Buffer> sender(int port, String host) {
        WriteStream<Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), Buffer.__TYPE_ARG);
        return ret;
    }

    public DatagramSocket send(String str, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(str, port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxSend(String str, int port, String host) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.send(str, port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket send(String str, String enc, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(str, enc, port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxSend(String str, String enc, int port, String host) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.send(str, enc, port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return new AsyncResultCompletable((Handler<Handler<AsyncResult<Void>>>)((Handler)handler -> this.close((Handler<AsyncResult<Void>>)handler)));
    }

    public void close() {
        this.delegate.close();
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxListenMulticastGroup(String multicastAddress) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.listenMulticastGroup(multicastAddress, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.unlistenMulticastGroup(multicastAddress, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket listen(int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<DatagramSocket> rxListen(int port, String host) {
        return new AsyncResultSingle<DatagramSocket>(handler -> this.listen(port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket pause() {
        this.delegate.pause();
        return this;
    }

    public DatagramSocket resume() {
        this.delegate.resume();
        return this;
    }

    public DatagramSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public DatagramSocket handler(final Handler<DatagramPacket> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.datagram.DatagramPacket>(){

            public void handle(io.vertx.core.datagram.DatagramPacket event) {
                handler.handle((Object)DatagramPacket.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

