/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.core.metrics.Measured;

@RxGen(value=io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor
implements Measured {
    public static final TypeArg<WorkerExecutor> __TYPE_ARG = new TypeArg<WorkerExecutor>(obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor)obj), WorkerExecutor::getDelegate);
    private final io.vertx.core.WorkerExecutor delegate;

    public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.WorkerExecutor getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, boolean ordered, final Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(Future.newInstance(event, TypeArg.unknown()));
            }
        }, ordered, new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered) {
        return new AsyncResultSingle(handler -> this.executeBlocking(blockingCodeHandler, ordered, (Handler)handler));
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, final Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(Future.newInstance(event, TypeArg.unknown()));
            }
        }, new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler) {
        return new AsyncResultSingle(handler -> this.executeBlocking(blockingCodeHandler, (Handler)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
        return arg != null ? new WorkerExecutor(arg) : null;
    }
}

