/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.reactivex.impl.ObservableUnmarshaller;
import java.util.Objects;
import java.util.function.Function;

public class SingleUnmarshaller<T, B>
implements SingleTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;
    private final ObjectCodec mapper;

    public SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this(unwrap, mappedType, null, null);
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this(unwrap, null, mappedTypeRef, null);
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, ObjectCodec mapper) {
        this(unwrap, mappedType, null, mapper);
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this(unwrap, null, mappedTypeRef, mapper);
    }

    private SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = mappedTypeRef;
        this.mapper = mapper;
    }

    public SingleSource<T> apply(@NonNull Single<B> upstream) {
        Single unwrapped = upstream.map(this.unwrap::apply);
        Single unmarshalled = unwrapped.flatMap(buffer -> {
            try {
                Object obj;
                if (this.mapper != null) {
                    JsonParser parser = this.mapper.getFactory().createParser(buffer.getBytes());
                    obj = Objects.nonNull(this.mappedType) ? this.mapper.readValue(parser, this.mappedType) : this.mapper.readValue(parser, this.mappedTypeRef);
                } else {
                    obj = ObservableUnmarshaller.getT(buffer, this.mappedType, this.mappedTypeRef);
                }
                return Single.just(obj);
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
        });
        return unmarshalled;
    }
}

