/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.reactivex.impl.ObservableUnmarshaller;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class FlowableUnmarshaller<T, B>
implements FlowableTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;
    private final ObjectCodec mapper;

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this(unwrap, mappedType, null, null);
    }

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this(unwrap, null, mappedTypeRef, null);
    }

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, ObjectCodec mapper) {
        this(unwrap, mappedType, null, mapper);
    }

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this(unwrap, null, mappedTypeRef, mapper);
    }

    private FlowableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = mappedTypeRef;
        this.mapper = mapper;
    }

    public Publisher<T> apply(@NonNull Flowable<B> upstream) {
        Flowable unwrapped = upstream.map(this.unwrap::apply);
        Single aggregated = unwrapped.collect(Buffer::buffer, Buffer::appendBuffer);
        Maybe unmarshalled = aggregated.toMaybe().concatMap(buffer -> {
            if (buffer.length() > 0) {
                try {
                    Object obj;
                    if (this.mapper != null) {
                        JsonParser parser = this.mapper.getFactory().createParser(buffer.getBytes());
                        obj = Objects.nonNull(this.mappedType) ? this.mapper.readValue(parser, this.mappedType) : this.mapper.readValue(parser, this.mappedTypeRef);
                    } else {
                        obj = ObservableUnmarshaller.getT(buffer, this.mappedType, this.mappedTypeRef);
                    }
                    return Maybe.just(obj);
                }
                catch (Exception e) {
                    return Maybe.error((Throwable)e);
                }
            }
            return Maybe.empty();
        });
        return unmarshalled.toFlowable();
    }
}

