/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FlowableReadStream<T, U>
extends Flowable<U> {
    public static final long DEFAULT_MAX_BUFFER_SIZE = 256L;
    private final ReadStream<T> stream;
    private final Function<T, U> f;
    private final AtomicReference<Subscription> current;

    public FlowableReadStream(ReadStream<T> stream, long maxBufferSize, Function<T, U> f) {
        stream.pause();
        this.stream = stream;
        this.f = f;
        this.current = new AtomicReference();
    }

    private void release() {
        Subscription sub = this.current.get();
        if (sub != null && this.current.compareAndSet(sub, null)) {
            try {
                this.stream.exceptionHandler(null);
                this.stream.endHandler(null);
                this.stream.handler(null);
            }
            catch (Exception exception) {
            }
            finally {
                this.stream.resume();
            }
        }
    }

    protected void subscribeActual(Subscriber<? super U> subscriber) {
        Subscription sub = new Subscription(){

            public void request(long l) {
                if (FlowableReadStream.this.current.get() == this) {
                    FlowableReadStream.this.stream.fetch(l);
                }
            }

            public void cancel() {
                FlowableReadStream.this.release();
            }
        };
        if (!this.current.compareAndSet(null, sub)) {
            EmptySubscription.error((Throwable)new IllegalStateException("This processor allows only a single Subscriber"), subscriber);
            return;
        }
        this.stream.pause();
        this.stream.endHandler(v -> {
            this.release();
            subscriber.onComplete();
        });
        this.stream.exceptionHandler(err -> {
            this.release();
            subscriber.onError(err);
        });
        this.stream.handler(item -> subscriber.onNext(this.f.apply(item)));
        subscriber.onSubscribe(sub);
    }
}

