/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class FlowableUnmarshaller<T, B>
implements FlowableTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;
    private final ObjectMapper mapper;

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this(unwrap, mappedType, null, Json.mapper);
    }

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this(unwrap, null, mappedTypeRef, Json.mapper);
    }

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, ObjectMapper mapper) {
        this(unwrap, mappedType, null, mapper);
    }

    public FlowableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        this(unwrap, null, mappedTypeRef, mapper);
    }

    private FlowableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = mappedTypeRef;
        this.mapper = mapper;
    }

    public Publisher<T> apply(@NonNull Flowable<B> upstream) {
        Flowable unwrapped = upstream.map(this.unwrap::apply);
        Single aggregated = unwrapped.collect(Buffer::buffer, Buffer::appendBuffer);
        Maybe unmarshalled = aggregated.toMaybe().concatMap(buffer -> {
            if (buffer.length() > 0) {
                try {
                    Object obj = Objects.nonNull(this.mappedType) ? this.mapper.readValue(buffer.getBytes(), this.mappedType) : this.mapper.readValue(buffer.getBytes(), this.mappedTypeRef);
                    return Maybe.just((Object)obj);
                }
                catch (IOException e) {
                    return Maybe.error((Throwable)e);
                }
            }
            return Maybe.empty();
        });
        return unmarshalled.toFlowable();
    }
}

