/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicationConnectOptions;
import io.vertx.redis.client.RedisTopology;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.RedisReplicationConnection;
import io.vertx.redis.client.impl.RedisURI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class RedisReplicationClient
extends BaseRedisClient<RedisReplicationConnectOptions>
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(RedisReplicationClient.class);

    public static void addMasterOnlyCommand(Command command) {
        RedisReplicationConnection.addMasterOnlyCommand(command);
    }

    public RedisReplicationClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, Supplier<Future<RedisReplicationConnectOptions>> connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        ((Future)this.connectOptions.get()).onSuccess(arg_0 -> this.lambda$connect$0((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    private void doConnect(RedisReplicationConnectOptions connectOptions, Completable<RedisConnection> promise) {
        List<String> endpoints = connectOptions.getEndpoints();
        if (connectOptions.getTopology() == RedisTopology.DISCOVER) {
            this.connectWithDiscoverTopology(new LinkedList<String>(endpoints), 0, ConcurrentHashMap.newKeySet(), connectOptions, promise);
        } else {
            this.connectWithStaticTopology(endpoints.get(0), endpoints.subList(1, endpoints.size()), connectOptions, promise);
        }
    }

    private void connectWithDiscoverTopology(List<String> endpoints, int index, Set<Throwable> failures, RedisReplicationConnectOptions connectOptions, Completable<RedisConnection> onConnect) {
        if (index >= endpoints.size()) {
            StringBuilder message = new StringBuilder("Cannot connect to any of the provided endpoints");
            for (Throwable failure : failures) {
                message.append("\n- ").append(failure);
            }
            onConnect.fail((Throwable)new RedisConnectException(message.toString()));
            return;
        }
        this.connectionManager.getConnection(endpoints.get(index), null).onFailure(err -> {
            failures.add((Throwable)err);
            this.connectWithDiscoverTopology(endpoints, index + 1, failures, connectOptions, onConnect);
        }).onSuccess(conn -> this.getReplicas((RedisConnection)conn, endpoints, index, (Completable<List<Node>>)((Completable)(replicas, err) -> {
            if (err != null) {
                conn.close();
                failures.add(err);
                this.connectWithDiscoverTopology(endpoints, index + 1, failures, connectOptions, onConnect);
                return;
            }
            AtomicInteger counter = new AtomicInteger();
            ArrayList<PooledRedisConnection> replicaConnections = new ArrayList<PooledRedisConnection>();
            for (Node replica : replicas) {
                if (!replica.online) {
                    LOG.info((Object)("Skipping offline replica: " + replica.ip + ":" + replica.port));
                    if (counter.incrementAndGet() != replicas.size()) continue;
                    onConnect.succeed((Object)new RedisReplicationConnection((Vertx)this.vertx, connectOptions, (PooledRedisConnection)conn, (List<PooledRedisConnection>)replicaConnections));
                    continue;
                }
                this.connectionManager.getConnection(replica.endpoint(), null).onFailure(error -> {
                    LOG.warn((Object)("Skipping failed replica: " + replica.ip + ":" + replica.port), error);
                    if (counter.incrementAndGet() == replicas.size()) {
                        onConnect.succeed((Object)new RedisReplicationConnection((Vertx)this.vertx, connectOptions, (PooledRedisConnection)conn, (List<PooledRedisConnection>)replicaConnections));
                    }
                }).onSuccess(replicaConnection -> {
                    List list = replicaConnections;
                    synchronized (list) {
                        replicaConnections.add((PooledRedisConnection)replicaConnection);
                    }
                    if (counter.incrementAndGet() == replicas.size()) {
                        onConnect.succeed((Object)new RedisReplicationConnection((Vertx)this.vertx, connectOptions, (PooledRedisConnection)conn, (List<PooledRedisConnection>)replicaConnections));
                    }
                });
            }
        })));
    }

    private void getReplicas(RedisConnection conn, List<String> endpoints, int index, Completable<List<Node>> onGetReplicas) {
        conn.send(Request.cmd(Command.INFO).arg("REPLICATION")).onFailure(arg_0 -> onGetReplicas.fail(arg_0)).onSuccess(info -> {
            Map<String, String> reply = this.parseInfo((Response)info);
            if (reply.isEmpty()) {
                onGetReplicas.fail("INFO REPLICATION No config available in the node.");
                return;
            }
            RedisURI uri = new RedisURI((String)endpoints.get(index));
            switch (reply.get("role")) {
                case "master": {
                    try {
                        int totalNodes = Integer.parseInt(reply.get("connected_slaves"));
                        ArrayList<Node> nodes = new ArrayList<Node>(totalNodes);
                        for (int i = 0; i < totalNodes; ++i) {
                            nodes.add(new Node(uri, reply.get("slave" + i)));
                        }
                        onGetReplicas.succeed(nodes);
                        return;
                    }
                    catch (RuntimeException e) {
                        onGetReplicas.fail((Throwable)e);
                        return;
                    }
                }
                case "slave": {
                    try {
                        String masterHost = reply.get("master_host");
                        String masterPort = reply.get("master_port");
                        endpoints.add(index + 1, uri.protocol() + "://" + uri.userinfo() + masterHost + ":" + masterPort);
                        onGetReplicas.fail("Connected to replica, retrying with master");
                        return;
                    }
                    catch (RuntimeException e) {
                        onGetReplicas.fail((Throwable)e);
                        return;
                    }
                }
            }
            onGetReplicas.fail("INFO REPLICATION invalid role: " + reply.get("role"));
        });
    }

    private void connectWithStaticTopology(String master, List<String> replicas, RedisReplicationConnectOptions connectOptions, Completable<RedisConnection> promise) {
        this.connectionManager.getConnection(master, null).onFailure(error -> promise.fail((Throwable)new RedisConnectException("Cannot connect to statically configured master: " + master + "\n- " + String.valueOf(error)))).onSuccess(masterConnection -> {
            AtomicInteger counter = new AtomicInteger();
            ArrayList replicaConnections = new ArrayList();
            for (String replica : replicas) {
                this.connectionManager.getConnection(replica, null).onFailure(err -> {
                    LOG.warn((Object)("Skipping failed replica: " + replica), err);
                    if (counter.incrementAndGet() == replicas.size()) {
                        promise.succeed((Object)new RedisReplicationConnection((Vertx)this.vertx, connectOptions, (PooledRedisConnection)masterConnection, replicaConnections));
                    }
                }).onSuccess(replicaConnection -> {
                    List list = replicaConnections;
                    synchronized (list) {
                        replicaConnections.add(replicaConnection);
                    }
                    if (counter.incrementAndGet() == replicas.size()) {
                        promise.succeed((Object)new RedisReplicationConnection((Vertx)this.vertx, connectOptions, (PooledRedisConnection)masterConnection, replicaConnections));
                    }
                });
            }
        });
    }

    private Map<String, String> parseInfo(Response response) {
        if (response == null) {
            return Collections.emptyMap();
        }
        String text = response.toString(StandardCharsets.ISO_8859_1);
        if (text == null || text.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] lines = text.split("\r\n");
        HashMap<String, String> info = new HashMap<String, String>();
        for (String line : lines) {
            int idx = line.indexOf(58);
            if (idx != -1) {
                info.put(line.substring(0, idx), line.substring(idx + 1));
                continue;
            }
            info.put(line, null);
        }
        return info;
    }

    private /* synthetic */ void lambda$connect$0(Promise promise, RedisReplicationConnectOptions opts) {
        this.doConnect(opts, (Completable<RedisConnection>)promise);
    }

    static {
        RedisReplicationClient.addMasterOnlyCommand(Command.WAIT);
    }

    static class Node {
        private final RedisURI parent;
        final String ip;
        final int port;
        final boolean online;

        Node(RedisURI parent, String raw) {
            this.parent = parent;
            String[] parts = raw.split(",");
            String _ip = null;
            String _port = "6379";
            String _state = null;
            block10: for (String part : parts) {
                String value;
                String key;
                int idx = part.indexOf(61);
                if (idx != -1) {
                    key = part.substring(0, idx);
                    value = part.substring(idx + 1);
                } else {
                    key = part;
                    value = null;
                }
                switch (key) {
                    case "ip": {
                        _ip = value;
                        continue block10;
                    }
                    case "port": {
                        _port = value;
                        continue block10;
                    }
                    case "state": {
                        _state = value;
                    }
                }
            }
            this.ip = _ip;
            this.port = Integer.parseInt(_port);
            this.online = "online".equals(_state);
        }

        String endpoint() {
            return this.parent.protocol() + "://" + this.parent.userinfo() + this.ip + ":" + this.port;
        }
    }
}

