/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisConnectOptions;
import java.util.ArrayList;
import java.util.Map;

public class RedisConnectOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "maxNestedArrays": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxNestedArrays(((Number)member.getValue()).intValue());
                    break;
                }
                case "protocolNegotiation": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setProtocolNegotiation((Boolean)member.getValue());
                    break;
                }
                case "preferredProtocolVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPreferredProtocolVersion(ProtocolVersion.valueOf((String)member.getValue()));
                    break;
                }
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "endpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEndpoints(list);
                    break;
                }
                case "maxWaitingHandlers": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitingHandlers(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(RedisConnectOptions obj, JsonObject json) {
        RedisConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(RedisConnectOptions obj, Map<String, Object> json) {
        json.put("maxNestedArrays", obj.getMaxNestedArrays());
        json.put("protocolNegotiation", obj.isProtocolNegotiation());
        if (obj.getPreferredProtocolVersion() != null) {
            json.put("preferredProtocolVersion", obj.getPreferredProtocolVersion().name());
        }
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getEndpoints() != null) {
            JsonArray array = new JsonArray();
            obj.getEndpoints().forEach(item -> array.add(item));
            json.put("endpoints", array);
        }
        json.put("maxWaitingHandlers", obj.getMaxWaitingHandlers());
    }
}

