/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.types.Multi;

public class EventBusHandler
implements Handler<Response> {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusHandler.class);
    private static final String DEFAULT_ADDRESS_PREFIX = "io.vertx.redis";
    private final String prefix;
    private final EventBus eventBus;

    public static EventBusHandler create(Vertx vertx) {
        return new EventBusHandler(DEFAULT_ADDRESS_PREFIX, vertx.eventBus());
    }

    public static EventBusHandler create(Vertx vertx, String addressPrefix) {
        return new EventBusHandler(addressPrefix, vertx.eventBus());
    }

    private EventBusHandler(String prefix, EventBus eventBus) {
        this.prefix = prefix;
        this.eventBus = eventBus;
    }

    public void handle(Response reply) {
        if (reply instanceof Multi) {
            String type = reply.get(0).toString();
            if (reply.size() == 3 && "message".equals(type)) {
                this.eventBus.send(this.prefix + "." + reply.get(1).toString(), (Object)new JsonObject().put("status", (Object)"OK").put("type", (Object)type).put("value", (Object)new JsonObject().put("channel", (Object)reply.get(1).toString()).put("message", (Object)reply.get(2).toString())));
                return;
            }
            if (reply.size() == 4 && "pmessage".equals(type)) {
                this.eventBus.send(this.prefix + "." + reply.get(1).toString(), (Object)new JsonObject().put("status", (Object)"OK").put("type", (Object)type).put("value", (Object)new JsonObject().put("pattern", (Object)reply.get(1).toString()).put("channel", (Object)reply.get(2).toString()).put("message", (Object)reply.get(3).toString())));
                return;
            }
            if (reply.size() == 3 && ("subscribe".equals(type) || "unsubscribe".equals(type))) {
                this.eventBus.send(this.prefix + "." + reply.get(1).toString(), (Object)new JsonObject().put("status", (Object)"OK").put("type", (Object)type).put("value", (Object)new JsonObject().put("channel", (Object)reply.get(1).toString()).put("current", (Object)reply.get(2).toLong())));
                return;
            }
            if (reply.size() == 3 && ("psubscribe".equals(type) || "punsubscribe".equals(type))) {
                this.eventBus.send(this.prefix + "." + reply.get(1).toString(), (Object)new JsonObject().put("status", (Object)"OK").put("type", (Object)type).put("value", (Object)new JsonObject().put("pattern", (Object)reply.get(1).toString()).put("current", (Object)reply.get(2).toLong())));
                return;
            }
        }
        LOG.warn((Object)("No handler waiting for message: " + String.valueOf(reply)));
    }
}

