/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisConnectOptionsConverter;
import io.vertx.redis.client.RedisOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public abstract class RedisConnectOptions {
    private String user;
    private String password;
    private List<String> endpoints;
    private int maxNestedArrays = 32;
    private boolean protocolNegotiation = true;
    private ProtocolVersion preferredProtocolVersion;
    private int maxWaitingHandlers = 2048;

    public RedisConnectOptions() {
    }

    public RedisConnectOptions(RedisOptions options) {
        this();
        this.setUser(options.getUser());
        this.setPassword(options.getPassword());
        this.setEndpoints(new ArrayList<String>(options.getEndpoints()));
        this.setMaxNestedArrays(options.getMaxNestedArrays());
        this.setProtocolNegotiation(options.isProtocolNegotiation());
        this.setPreferredProtocolVersion(options.getPreferredProtocolVersion());
        this.setMaxWaitingHandlers(options.getMaxWaitingHandlers());
    }

    public RedisConnectOptions(RedisConnectOptions other) {
        this();
        this.setUser(other.getUser());
        this.setPassword(other.getPassword());
        this.setEndpoints(new ArrayList<String>(other.getEndpoints()));
        this.setMaxNestedArrays(other.getMaxNestedArrays());
        this.setProtocolNegotiation(other.isProtocolNegotiation());
        this.setPreferredProtocolVersion(other.getPreferredProtocolVersion());
        this.setMaxWaitingHandlers(other.getMaxWaitingHandlers());
    }

    public RedisConnectOptions(JsonObject json) {
        this();
        RedisConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public int getMaxNestedArrays() {
        return this.maxNestedArrays;
    }

    public RedisConnectOptions setMaxNestedArrays(int maxNestedArrays) {
        this.maxNestedArrays = maxNestedArrays;
        return this;
    }

    public boolean isProtocolNegotiation() {
        return this.protocolNegotiation;
    }

    public RedisConnectOptions setProtocolNegotiation(boolean protocolNegotiation) {
        this.protocolNegotiation = protocolNegotiation;
        return this;
    }

    public ProtocolVersion getPreferredProtocolVersion() {
        return this.preferredProtocolVersion;
    }

    public RedisConnectOptions setPreferredProtocolVersion(ProtocolVersion preferredProtocolVersion) {
        this.preferredProtocolVersion = preferredProtocolVersion;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public RedisConnectOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RedisConnectOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    @GenIgnore
    public String getEndpoint() {
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            return "redis://localhost:6379";
        }
        return this.endpoints.get(0);
    }

    @GenIgnore
    public RedisConnectOptions addConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    @GenIgnore
    public RedisConnectOptions setConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public List<String> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
            this.endpoints.add("redis://localhost:6379");
        }
        return this.endpoints;
    }

    public RedisConnectOptions setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public int getMaxWaitingHandlers() {
        return this.maxWaitingHandlers;
    }

    public RedisConnectOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        this.maxWaitingHandlers = maxWaitingHandlers;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RedisConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

