/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisClusterConnection;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.SharedSlots;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.NumberType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class RedisClusterClient
extends BaseRedisClient
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterClient.class);
    final RedisClusterConnectOptions connectOptions;
    final SharedSlots sharedSlots;

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        RedisClusterConnection.addReducer(command, fn);
    }

    public static void addMasterOnlyCommand(Command command) {
        RedisClusterConnection.addMasterOnlyCommand(command);
    }

    public RedisClusterClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, RedisClusterConnectOptions connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        this.connectOptions = connectOptions;
        this.sharedSlots = new SharedSlots(vertx, connectOptions, this.connectionManager);
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        this.sharedSlots.get().onSuccess(arg_0 -> this.lambda$connect$11((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    private void connect(Slots slots, Handler<AsyncResult<RedisConnection>> onConnected) {
        ConcurrentHashMap failures = new ConcurrentHashMap();
        AtomicInteger counter = new AtomicInteger();
        HashMap connections = new HashMap();
        for (String endpoint : slots.endpoints()) {
            this.connectionManager.getConnection(endpoint, RedisReplicas.NEVER != this.connectOptions.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
                failures.put(endpoint, err);
                this.connectionComplete(counter, slots, connections, failures, onConnected);
            }).onSuccess(cconn -> {
                Map map = connections;
                synchronized (map) {
                    connections.put(endpoint, cconn);
                }
                this.connectionComplete(counter, slots, connections, failures, onConnected);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionComplete(AtomicInteger counter, Slots slots, Map<String, PooledRedisConnection> connections, Map<String, Throwable> failures, Handler<AsyncResult<RedisConnection>> onConnected) {
        if (counter.incrementAndGet() == slots.endpoints().length) {
            if (!failures.isEmpty()) {
                Map<String, PooledRedisConnection> map = connections;
                synchronized (map) {
                    for (RedisConnection redisConnection : connections.values()) {
                        if (redisConnection == null) continue;
                        redisConnection.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
                    }
                }
                StringBuilder message = new StringBuilder("Failed to connect to all nodes of the cluster");
                for (Map.Entry entry : failures.entrySet()) {
                    message.append(String.format("\n- %s: %s", entry.getKey(), ((Throwable)entry.getValue()).getMessage()));
                }
                onConnected.handle((Object)Future.failedFuture((Throwable)new RedisConnectException(message.toString())));
            } else {
                onConnected.handle((Object)Future.succeededFuture((Object)new RedisClusterConnection((Vertx)this.vertx, this.connectionManager, this.connectOptions, this.sharedSlots, connections)));
            }
        }
    }

    private /* synthetic */ void lambda$connect$11(Promise promise, Slots slots) {
        this.connect(slots, (Handler<AsyncResult<RedisConnection>>)promise);
    }

    static {
        RedisClusterClient.addReducer(Command.MSET, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DEL, list -> NumberType.create(list.stream().mapToLong(el -> {
            Long l = el.toLong();
            if (l == null) {
                return 0L;
            }
            return l;
        }).sum()));
        RedisClusterClient.addReducer(Command.MGET, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.KEYS, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.FLUSHDB, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DBSIZE, list -> NumberType.create(list.stream().mapToLong(el -> {
            Long l = el.toLong();
            if (l == null) {
                return 0L;
            }
            return l;
        }).sum()));
        RedisClusterClient.addMasterOnlyCommand(Command.WAIT);
        RedisClusterClient.addMasterOnlyCommand(Command.SUBSCRIBE);
        RedisClusterClient.addMasterOnlyCommand(Command.PSUBSCRIBE);
        RedisClusterClient.addMasterOnlyCommand(Command.SSUBSCRIBE);
        RedisClusterClient.addReducer(Command.UNSUBSCRIBE, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.PUNSUBSCRIBE, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.SUNSUBSCRIBE, list -> SimpleStringType.OK);
    }
}

