/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisSentinelConnection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class SentinelFailover {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelFailover.class);
    private final Vertx vertx;
    private final String masterSetName;
    private final Function<RedisRole, Future<PooledRedisConnection>> connectionFactory;
    private final AtomicReference<PooledRedisConnection> sentinelConnection = new AtomicReference();
    private final Set<RedisSentinelConnection> masterConnections = ConcurrentHashMap.newKeySet();
    private volatile boolean closed;

    SentinelFailover(Vertx vertx, String masterSetName, Function<RedisRole, Future<PooledRedisConnection>> connectionFactory) {
        this.vertx = vertx;
        this.masterSetName = masterSetName;
        this.connectionFactory = connectionFactory;
    }

    void start() {
        if (this.closed) {
            return;
        }
        this.connectionFactory.apply(RedisRole.SENTINEL).onFailure(t -> {
            LOG.error((Object)("Failed to obtain a connection to Redis sentinel, will retry in 1 second: " + t));
            this.vertx.setTimer(1000L, ignored -> this.start());
        }).onSuccess(sentinel -> {
            PooledRedisConnection old = this.sentinelConnection.getAndSet((PooledRedisConnection)sentinel);
            if (old != null) {
                old.close().onFailure(err -> LOG.warn((Object)("Failed to close connection: " + err)));
            }
            sentinel.handler(msg -> {
                if (msg.type() == ResponseType.PUSH && "message".equalsIgnoreCase(msg.get(0).toString()) && msg.get(2).toString().startsWith(this.masterSetName + " ")) {
                    this.reconnectAll();
                }
            });
            sentinel.exceptionHandler(t -> {
                LOG.error((Object)("Connection to Redis sentinel failed, will start over in 1 second: " + t));
                sentinel.close();
                this.vertx.setTimer(1000L, ignored -> this.start());
            });
            sentinel.send(Request.cmd(Command.SUBSCRIBE).arg("+switch-master")).onFailure(t -> {
                LOG.error((Object)("Failed subscribing to +switch-master, will start over in 1 second: " + t));
                sentinel.close();
                this.vertx.setTimer(1000L, ignored -> this.start());
            });
        });
    }

    private void reconnectAll() {
        for (RedisSentinelConnection connection : this.masterConnections) {
            connection.closeDelegate().recover(ignored -> Future.succeededFuture()).compose(ignored -> this.connectionFactory.apply(RedisRole.MASTER)).onSuccess(connection::reconnect).onFailure(t -> LOG.error((Object)("Failed to reconnect to master after failover: " + t)));
        }
    }

    void addConnection(RedisSentinelConnection sentinelConn) {
        this.masterConnections.add(sentinelConn);
    }

    void removeConnection(RedisSentinelConnection sentinelConn) {
        this.masterConnections.remove(sentinelConn);
    }

    void close() {
        this.closed = true;
        PooledRedisConnection sentinelConnection = this.sentinelConnection.get();
        if (sentinelConnection != null) {
            sentinelConnection.close().onFailure(err -> LOG.warn((Object)("Failed to close connection: " + err)));
        }
    }
}

