/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetClientImpl;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionManager;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Endpoint;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RESPParser;
import io.vertx.redis.client.impl.RedisConnectionInternal;
import io.vertx.redis.client.impl.RedisStandaloneConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.List;
import java.util.Objects;

class RedisConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConnectionManager.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> LOG.error((Object)"Unhandled Error", t);
    private final VertxInternal vertx;
    private final ContextInternal context;
    private final NetClientImpl netClient;
    private final PoolMetrics metrics;
    private final NetClientOptions tcpOptions;
    private final PoolOptions poolOptions;
    private final RedisConnectOptions connectOptions;
    private final TracingPolicy tracingPolicy;
    private final ConnectionManager<ConnectionKey, Lease<RedisConnectionInternal>> pooledConnectionManager;
    private long timerID;

    RedisConnectionManager(VertxInternal vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, RedisConnectOptions connectOptions, TracingPolicy tracingPolicy) {
        this.vertx = vertx;
        this.context = vertx.getOrCreateContext();
        this.tcpOptions = tcpOptions;
        this.poolOptions = poolOptions;
        this.connectOptions = connectOptions;
        this.tracingPolicy = tracingPolicy;
        VertxMetrics metricsSPI = this.vertx.metricsSPI();
        this.metrics = metricsSPI != null ? metricsSPI.createPoolMetrics("redis", poolOptions.getName(), poolOptions.getMaxSize()) : null;
        this.netClient = (NetClientImpl)vertx.createNetClient(tcpOptions);
        this.pooledConnectionManager = new ConnectionManager();
    }

    private Endpoint<Lease<RedisConnectionInternal>> connectionEndpointProvider(ContextInternal ctx, Runnable dispose, String connectionString, Request setup) {
        return new RedisEndpoint(this.vertx, this.netClient, this.tcpOptions, this.poolOptions, this.connectOptions, this.tracingPolicy, dispose, connectionString, setup);
    }

    synchronized void start() {
        long period = this.poolOptions.getCleanerInterval();
        this.timerID = period > 0L ? this.vertx.setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private void checkExpired(long period) {
        this.pooledConnectionManager.forEach(e -> ((RedisEndpoint)e).pool.evict(conn -> !conn.isValid(), ar -> {
            if (ar.succeeded()) {
                for (RedisConnectionInternal conn : (List)ar.result()) {
                    conn.handler((Handler)null);
                    conn.endHandler((Handler)null);
                    conn.exceptionHandler((Handler)null);
                    conn.forceClose();
                }
            }
        }));
        this.timerID = this.vertx.setTimer(period, id -> this.checkExpired(period));
    }

    public Future<PooledRedisConnection> getConnection(String connectionString, Request setup) {
        PromiseInternal promise = this.vertx.promise();
        ContextInternal eventLoopContext = this.context.isEventLoopContext() ? this.context : this.vertx.createEventLoopContext(this.context.nettyEventLoop(), this.context.workerPool(), this.context.classLoader());
        boolean metricsEnabled = this.metrics != null;
        Object queueMetric = metricsEnabled ? this.metrics.submitted() : null;
        this.pooledConnectionManager.getConnection(eventLoopContext, (Object)new ConnectionKey(connectionString, setup), (ctx, dispose) -> this.connectionEndpointProvider(ctx, dispose, connectionString, setup), (Handler)promise);
        return promise.future().onFailure(err -> {
            if (metricsEnabled) {
                this.metrics.rejected(queueMetric);
            }
        }).compose(lease -> Future.succeededFuture((Object)new PooledRedisConnection((Lease<RedisConnectionInternal>)lease, this.metrics, metricsEnabled ? this.metrics.begin(queueMetric) : null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RedisConnectionManager redisConnectionManager = this;
        synchronized (redisConnectionManager) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.pooledConnectionManager.close();
        this.netClient.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    static class RedisEndpoint
    extends Endpoint<Lease<RedisConnectionInternal>> {
        final ConnectionPool<RedisConnectionInternal> pool;

        public RedisEndpoint(VertxInternal vertx, NetClientImpl netClient, NetClientOptions netClientOptions, PoolOptions poolOptions, RedisConnectOptions connectOptions, TracingPolicy tracingPolicy, Runnable dispose, String connectionString, Request setup) {
            super(dispose);
            RedisConnectionProvider connector = new RedisConnectionProvider(vertx, netClient, netClientOptions, poolOptions, connectOptions, tracingPolicy, connectionString, setup);
            this.pool = ConnectionPool.pool((PoolConnector)connector, (int[])new int[]{poolOptions.getMaxSize()}, (int)poolOptions.getMaxWaiting());
        }

        public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Lease<RedisConnectionInternal>>> handler) {
            this.pool.acquire(ctx, 0, ar -> {
                if (ar.succeeded()) {
                    this.incRefCount();
                    ((RedisStandaloneConnection)((Lease)ar.result()).get()).evictHandler(() -> ((RedisEndpoint)this).decRefCount());
                }
                handler.handle(ar);
            });
        }
    }

    static class RedisConnectionProvider
    implements PoolConnector<RedisConnectionInternal> {
        private final VertxInternal vertx;
        private final NetClientImpl netClient;
        private final RedisURI redisURI;
        private final Request setup;
        private final NetClientOptions netClientOptions;
        private final PoolOptions poolOptions;
        private final RedisConnectOptions options;
        private final TracingPolicy tracingPolicy;

        public RedisConnectionProvider(VertxInternal vertx, NetClientImpl netClient, NetClientOptions netClientOptions, PoolOptions poolOptions, RedisConnectOptions options, TracingPolicy tracingPolicy, String connectionString, Request setup) {
            this.vertx = vertx;
            this.netClient = netClient;
            this.netClientOptions = netClientOptions;
            this.poolOptions = poolOptions;
            this.options = options;
            this.tracingPolicy = tracingPolicy;
            this.redisURI = new RedisURI(connectionString);
            this.setup = setup;
        }

        public boolean isValid(RedisConnectionInternal conn) {
            return conn.isValid();
        }

        public void connect(ContextInternal ctx, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<RedisConnectionInternal>>> onConnect) {
            boolean netClientSsl = this.netClientOptions.isSsl();
            boolean connectionStringSsl = this.redisURI.ssl();
            boolean connectionStringInetSocket = this.redisURI.socketAddress().isInetSocket();
            if (connectionStringInetSocket && netClientSsl && !connectionStringSsl) {
                ctx.execute((Object)ctx.failedFuture("Pool initialized with SSL but connection requested plain socket"), onConnect);
                return;
            }
            try {
                this.netClient.connect(ctx, this.redisURI.socketAddress(), null).onComplete(clientConnect -> {
                    if (clientConnect.failed()) {
                        ctx.execute((Object)ctx.failedFuture(clientConnect.cause()), onConnect);
                        return;
                    }
                    NetSocket netSocket = (NetSocket)clientConnect.result();
                    if (connectionStringInetSocket && !netClientSsl && connectionStringSsl) {
                        netSocket.upgradeToSsl(upgradeToSsl -> {
                            if (upgradeToSsl.failed()) {
                                ctx.execute((Object)ctx.failedFuture(upgradeToSsl.cause()), onConnect);
                            } else {
                                this.init(ctx, netSocket, listener, onConnect);
                            }
                        });
                    } else {
                        this.init(ctx, netSocket, listener, onConnect);
                    }
                });
            }
            catch (RuntimeException err) {
                ctx.execute((Object)ctx.failedFuture((Throwable)err), onConnect);
            }
        }

        private void init(ContextInternal ctx, NetSocket netSocket, PoolConnector.Listener connectionListener, Handler<AsyncResult<ConnectResult<RedisConnectionInternal>>> onConnect) {
            VertxMetrics vertxMetrics = this.vertx.metricsSPI();
            ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(this.redisURI.socketAddress(), "redis", this.netClientOptions.getMetricsName()) : null;
            RedisStandaloneConnection connection = new RedisStandaloneConnection(this.vertx, ctx, connectionListener, netSocket, this.poolOptions, this.options.getMaxWaitingHandlers(), this.redisURI, metrics, this.tracingPolicy);
            connection.exceptionHandler(DEFAULT_EXCEPTION_HANDLER);
            netSocket.handler((Handler)new RESPParser(connection, this.options.getMaxNestedArrays())).closeHandler(connection::end).exceptionHandler(connection::fail);
            this.hello(ctx, connection, this.redisURI, (Handler<AsyncResult<Void>>)((Handler)hello -> {
                if (hello.failed()) {
                    ctx.execute((Object)ctx.failedFuture(hello.cause()), onConnect);
                    return;
                }
                this.select(ctx, connection, this.redisURI.select(), (Handler<AsyncResult<Void>>)((Handler)select -> {
                    if (select.failed()) {
                        ctx.execute((Object)ctx.failedFuture(select.cause()), onConnect);
                        return;
                    }
                    this.setup(ctx, connection, this.setup, (Handler<AsyncResult<Void>>)((Handler)setupResult -> {
                        if (setupResult.failed()) {
                            ctx.execute((Object)ctx.failedFuture(setupResult.cause()), onConnect);
                            return;
                        }
                        connection.setValid();
                        ctx.execute((Object)ctx.succeededFuture((Object)new ConnectResult((Object)connection, 1L, 0L)), onConnect);
                    }));
                }));
            }));
        }

        private void hello(ContextInternal ctx, RedisConnection connection, RedisURI redisURI, Handler<AsyncResult<Void>> handler) {
            if (!this.options.isProtocolNegotiation()) {
                this.ping(ctx, connection, handler);
            } else {
                String client;
                String version = "3";
                if (this.options.getPreferredProtocolVersion() != null) {
                    version = this.options.getPreferredProtocolVersion().getValue();
                }
                Request hello = Request.cmd(Command.HELLO).arg(version);
                String password = redisURI.password() != null ? redisURI.password() : this.options.getPassword();
                String user = redisURI.user();
                if (password != null) {
                    hello.arg("AUTH").arg(user == null ? "default" : user).arg(password);
                }
                if ((client = redisURI.param("client")) != null) {
                    hello.arg("SETNAME").arg(client);
                }
                connection.send(hello, (Handler<AsyncResult<Response>>)((Handler)onSend -> {
                    if (onSend.succeeded()) {
                        LOG.debug(onSend.result());
                        ctx.execute((Object)ctx.succeededFuture(), handler);
                        return;
                    }
                    Throwable err = onSend.cause();
                    if (err != null && err instanceof ErrorType) {
                        ErrorType redisErr = (ErrorType)err;
                        if (redisErr.is("NOAUTH") || redisErr.is("WRONGPASS")) {
                            this.authenticate(ctx, connection, user, password, handler);
                            return;
                        }
                        if (redisErr.is("ERR")) {
                            String msg = redisErr.getMessage();
                            if (msg.startsWith("ERR unknown command") || msg.startsWith("ERR unknown or unsupported command")) {
                                this.ping(ctx, connection, handler);
                            }
                            return;
                        }
                    }
                    ctx.execute((Object)ctx.failedFuture(err), handler);
                }));
            }
        }

        private void ping(ContextInternal ctx, RedisConnection connection, Handler<AsyncResult<Void>> handler) {
            Request ping = Request.cmd(Command.PING);
            connection.send(ping, (Handler<AsyncResult<Response>>)((Handler)onSend -> {
                if (onSend.succeeded()) {
                    LOG.debug(onSend.result());
                    ctx.execute((Object)ctx.succeededFuture(), handler);
                    return;
                }
                Throwable err = onSend.cause();
                if (err != null && err instanceof ErrorType && ((ErrorType)err).is("NOAUTH")) {
                    String password = this.redisURI.password() != null ? this.redisURI.password() : this.options.getPassword();
                    this.authenticate(ctx, connection, this.redisURI.user(), password, handler);
                    return;
                }
                ctx.execute((Object)ctx.failedFuture(err), handler);
            }));
        }

        private void authenticate(ContextInternal ctx, RedisConnection connection, String user, String password, Handler<AsyncResult<Void>> handler) {
            if (password == null) {
                ctx.execute((Object)ctx.succeededFuture(), handler);
                return;
            }
            Request cmd = Request.cmd(Command.AUTH);
            if (user != null) {
                cmd.arg(user);
            }
            cmd.arg(password);
            connection.send(cmd, (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    ctx.execute((Object)ctx.failedFuture(auth.cause()), handler);
                } else {
                    ctx.execute((Object)ctx.succeededFuture(), handler);
                }
            }));
        }

        private void select(ContextInternal ctx, RedisConnection connection, Integer select, Handler<AsyncResult<Void>> handler) {
            if (select == null) {
                ctx.execute((Object)ctx.succeededFuture(), handler);
                return;
            }
            connection.send(Request.cmd(Command.SELECT).arg(select), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    ctx.execute((Object)ctx.failedFuture(auth.cause()), handler);
                } else {
                    ctx.execute((Object)ctx.succeededFuture(), handler);
                }
            }));
        }

        private void setup(ContextInternal ctx, RedisConnection connection, Request setup, Handler<AsyncResult<Void>> handler) {
            if (setup == null) {
                ctx.execute((Object)ctx.succeededFuture(), handler);
                return;
            }
            connection.send(setup, (Handler<AsyncResult<Response>>)((Handler)req -> {
                if (req.failed()) {
                    ctx.execute((Object)ctx.failedFuture(req.cause()), handler);
                } else {
                    ctx.execute((Object)ctx.succeededFuture(), handler);
                }
            }));
        }
    }

    static class ConnectionKey {
        private final String string;
        private final Request setup;

        ConnectionKey(String string, Request setup) {
            this.string = string;
            this.setup = setup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            return Objects.equals(this.string, that.string) && Objects.equals(this.setup, that.setup);
        }

        public int hashCode() {
            return Objects.hash(this.string, this.setup);
        }
    }
}

