/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.KeyExtractor;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.RequestImpl;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.ZModem;
import io.vertx.redis.client.impl.types.ErrorType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.function.Function;

public class RedisClusterConnection
implements RedisConnection {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterConnection.class);
    private static final SplittableRandom RANDOM = new SplittableRandom();
    private static final int RETRIES = 16;
    private static final Map<Command, String> UNSUPPORTEDCOMMANDS = new HashMap<Command, String>();
    private static final Map<Command, Function<List<Response>, Response>> REDUCERS = new HashMap<Command, Function<List<Response>, Response>>();
    private static final List<Command> MASTER_ONLY_COMMANDS = new ArrayList<Command>();
    private final VertxInternal vertx;
    private final RedisOptions options;
    private final Slots slots;
    private final Map<String, RedisConnection> connections;

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        REDUCERS.put(command, fn);
    }

    public static void addUnSupportedCommand(Command command, String error) {
        if (error == null || error.isEmpty()) {
            UNSUPPORTEDCOMMANDS.put(command, "RedisClusterClient does not handle command " + new String(command.getBytes(), StandardCharsets.ISO_8859_1).split("\r\n")[1] + ", use non cluster client on the right node.");
        } else {
            UNSUPPORTEDCOMMANDS.put(command, error);
        }
    }

    public static void addMasterOnlyCommand(Command command) {
        MASTER_ONLY_COMMANDS.add(command);
    }

    RedisClusterConnection(Vertx vertx, RedisOptions options, Slots slots, Map<String, RedisConnection> connections) {
        this.vertx = (VertxInternal)vertx;
        this.options = options;
        this.slots = slots;
        this.connections = connections;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.exceptionHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.handler((Handler)handler);
        }
        return this;
    }

    @Override
    public RedisConnection pause() {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.pause();
        }
        return this;
    }

    @Override
    public RedisConnection resume() {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.resume();
        }
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.fetch(amount);
        }
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> handler) {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.endHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public Future<Response> send(Request request) {
        PromiseInternal promise = this.vertx.promise();
        RequestImpl req = (RequestImpl)request;
        Command cmd = req.command();
        boolean forceMasterEndpoint = MASTER_ONLY_COMMANDS.contains(cmd);
        if (UNSUPPORTEDCOMMANDS.containsKey(cmd)) {
            promise.fail(UNSUPPORTEDCOMMANDS.get(cmd));
            return promise.future();
        }
        if (cmd.isMovable()) {
            byte[][] keys = KeyExtractor.extractMovableKeys(req);
            int hashSlot = ZModem.generateMulti(keys);
            if (hashSlot == -1) {
                promise.fail(this.buildCrossslotFailureMsg(req));
                return promise.future();
            }
            String[] endpoints = this.slots.endpointsForKey(hashSlot);
            this.send(this.selectMasterOrReplicaEndpoint(req.command().isReadOnly(), endpoints, forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
            return promise.future();
        }
        if (cmd.isKeyless() && REDUCERS.containsKey(cmd)) {
            ArrayList<Future> responses = new ArrayList<Future>(this.slots.size());
            for (int i = 0; i < this.slots.size(); ++i) {
                String[] endpoints = this.slots.endpointsForSlot(i);
                Promise p = Promise.promise();
                this.send(this.selectMasterOrReplicaEndpoint(req.command().isReadOnly(), endpoints, forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)p);
                responses.add(p.future());
            }
            CompositeFuture.all(responses).onComplete(arg_0 -> RedisClusterConnection.lambda$send$0((Promise)promise, cmd, arg_0));
            return promise.future();
        }
        if (cmd.isKeyless()) {
            this.send(this.selectEndpoint(-1, cmd.isReadOnly(), forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
            return promise.future();
        }
        List<byte[]> args = req.getArgs();
        if (cmd.isMultiKey()) {
            int currentSlot = -1;
            int start = cmd.getFirstKey() - 1;
            int end = cmd.getLastKey();
            if (end > 0) {
                --end;
            }
            if (end < 0) {
                end = args.size() + (end + 1);
            }
            int step = cmd.getInterval();
            for (int i = start; i < end; i += step) {
                int slot = ZModem.generate(args.get(i));
                if (currentSlot == -1) {
                    currentSlot = slot;
                    continue;
                }
                if (currentSlot == slot) continue;
                if (!REDUCERS.containsKey(cmd)) {
                    promise.fail(this.buildCrossslotFailureMsg(req));
                    return promise.future();
                }
                Map<Integer, Request> requests = this.splitRequest(cmd, args, start, end, step);
                ArrayList<Future> responses = new ArrayList<Future>(requests.size());
                for (Map.Entry<Integer, Request> kv : requests.entrySet()) {
                    Promise p = Promise.promise();
                    this.send(this.selectEndpoint(kv.getKey(), cmd.isReadOnly(), forceMasterEndpoint), 16, kv.getValue(), (Handler<AsyncResult<Response>>)p);
                    responses.add(p.future());
                }
                CompositeFuture.all(responses).onComplete(arg_0 -> RedisClusterConnection.lambda$send$1((Promise)promise, cmd, arg_0));
                return promise.future();
            }
            this.send(this.selectEndpoint(currentSlot, cmd.isReadOnly(), forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
            return promise.future();
        }
        int start = cmd.getFirstKey() - 1;
        this.send(this.selectEndpoint(ZModem.generate(args.get(start)), cmd.isReadOnly(), forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
        return promise.future();
    }

    private Map<Integer, Request> splitRequest(Command cmd, List<byte[]> args, int start, int end, int step) {
        IdentityHashMap<Integer, Request> map = new IdentityHashMap<Integer, Request>();
        for (int i = start; i < end; i += step) {
            int j;
            int slot = ZModem.generate(args.get(i));
            Request request = (Request)map.get(slot);
            if (request == null) {
                request = Request.cmd(cmd);
                for (j = 0; j < start; ++j) {
                    request.arg(args.get(j));
                }
                map.put(slot, request);
            }
            request.arg(args.get(i));
            for (j = i + 1; j < i + step; ++j) {
                request.arg(args.get(j));
            }
        }
        Collection col = map.values();
        col.forEach(req -> {
            for (int j = end; j < args.size(); ++j) {
                req.arg((byte[])args.get(j));
            }
        });
        return map;
    }

    private void send(String endpoint, int retries, Request command, Handler<AsyncResult<Response>> handler) {
        RedisConnection connection = this.connections.get(endpoint);
        if (connection == null) {
            handler.handle((Object)Future.failedFuture((String)("Missing connection to: " + endpoint)));
            return;
        }
        connection.send(command, (Handler<AsyncResult<Response>>)((Handler)send -> {
            if (send.failed() && send.cause() instanceof ErrorType && retries >= 0) {
                ErrorType cause = (ErrorType)send.cause();
                if (cause.is("MOVED")) {
                    handler.handle((Object)Future.failedFuture((Throwable)cause));
                    return;
                }
                if (cause.is("ASK")) {
                    connection.send(Request.cmd(Command.ASKING), (Handler<AsyncResult<Response>>)((Handler)asking -> {
                        if (asking.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)asking.cause()));
                            return;
                        }
                        String addr = cause.slice(' ', 2);
                        if (addr == null) {
                            handler.handle((Object)Future.failedFuture((Throwable)cause));
                            return;
                        }
                        RedisURI uri = new RedisURI(endpoint);
                        this.send(uri.protocol() + "://" + uri.userinfo() + addr, retries - 1, command, handler);
                    }));
                    return;
                }
                if (cause.is("TRYAGAIN") || cause.is("CLUSTERDOWN")) {
                    long backoff = (long)(Math.pow(2.0, 16 - Math.max(retries, 9)) * 10.0);
                    this.vertx.setTimer(backoff, t -> this.send(endpoint, retries - 1, command, handler));
                    return;
                }
                if (cause.is("NOAUTH") && this.options.getPassword() != null) {
                    connection.send(Request.cmd(Command.AUTH).arg(this.options.getPassword()), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                        if (auth.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                            return;
                        }
                        this.send(endpoint, retries - 1, command, handler);
                    }));
                    return;
                }
            }
            try {
                handler.handle(send);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Handler failure", (Throwable)e);
            }
        }));
    }

    @Override
    public Future<List<Response>> batch(List<Request> requests) {
        PromiseInternal promise = this.vertx.promise();
        int currentSlot = -1;
        boolean readOnly = false;
        boolean forceMasterEndpoint = false;
        for (Request request : requests) {
            int start;
            RequestImpl req = (RequestImpl)request;
            Command cmd = req.command();
            if (UNSUPPORTEDCOMMANDS.containsKey(cmd)) {
                promise.fail(UNSUPPORTEDCOMMANDS.get(cmd));
                return promise.future();
            }
            readOnly |= cmd.isReadOnly();
            forceMasterEndpoint |= MASTER_ONLY_COMMANDS.contains(cmd);
            if (cmd.isKeyless()) continue;
            if (cmd.isMovable()) {
                byte[][] keys = KeyExtractor.extractMovableKeys(req);
                int slot = ZModem.generateMulti(keys);
                if (slot == -1 || currentSlot != -1 && currentSlot != slot) {
                    promise.fail(this.buildCrossslotFailureMsg(req));
                    return promise.future();
                }
                currentSlot = slot;
                continue;
            }
            List<byte[]> args = req.getArgs();
            if (cmd.isMultiKey()) {
                start = cmd.getFirstKey() - 1;
                int end = cmd.getLastKey();
                if (end > 0) {
                    --end;
                }
                if (end < 0) {
                    end = args.size() + (end + 1);
                }
                int step = cmd.getInterval();
                for (int j = start; j < end; j += step) {
                    int slot = ZModem.generate(args.get(j));
                    if (currentSlot == -1) {
                        currentSlot = slot;
                        continue;
                    }
                    if (currentSlot == slot) continue;
                    promise.fail(this.buildCrossslotFailureMsg(req));
                    return promise.future();
                }
                continue;
            }
            start = cmd.getFirstKey() - 1;
            int slot = ZModem.generate(args.get(start));
            if (currentSlot == -1) {
                currentSlot = slot;
                continue;
            }
            if (currentSlot == slot) continue;
            promise.fail(this.buildCrossslotFailureMsg(req));
            return promise.future();
        }
        this.batch(this.selectEndpoint(currentSlot, readOnly, forceMasterEndpoint), 16, requests, (Handler<AsyncResult<List<Response>>>)promise);
        return promise.future();
    }

    private void batch(String endpoint, int retries, List<Request> commands, Handler<AsyncResult<List<Response>>> handler) {
        RedisConnection connection = this.connections.get(endpoint);
        if (connection == null) {
            handler.handle((Object)Future.failedFuture((String)("Missing connection to: " + endpoint)));
            return;
        }
        connection.batch(commands, (Handler<AsyncResult<List<Response>>>)((Handler)send -> {
            if (send.failed() && send.cause() instanceof ErrorType && retries >= 0) {
                ErrorType cause = (ErrorType)send.cause();
                if (cause.is("MOVED")) {
                    handler.handle((Object)Future.failedFuture((Throwable)cause));
                    return;
                }
                if (cause.is("ASK")) {
                    connection.send(Request.cmd(Command.ASKING), (Handler<AsyncResult<Response>>)((Handler)asking -> {
                        if (asking.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)asking.cause()));
                            return;
                        }
                        String addr = cause.slice(' ', 2);
                        if (addr == null) {
                            handler.handle((Object)Future.failedFuture((Throwable)cause));
                            return;
                        }
                        RedisURI uri = new RedisURI(endpoint);
                        this.batch(uri.protocol() + "://" + uri.userinfo() + addr, retries - 1, commands, handler);
                    }));
                    return;
                }
                if (cause.is("TRYAGAIN") || cause.is("CLUSTERDOWN")) {
                    long backoff = (long)(Math.pow(2.0, 16 - Math.max(retries, 9)) * 10.0);
                    this.vertx.setTimer(backoff, t -> this.batch(endpoint, retries - 1, commands, handler));
                    return;
                }
                if (cause.is("NOAUTH") && this.options.getPassword() != null) {
                    connection.send(Request.cmd(Command.AUTH).arg(this.options.getPassword()), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                        if (auth.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                            return;
                        }
                        this.batch(endpoint, retries - 1, commands, handler);
                    }));
                    return;
                }
            }
            try {
                handler.handle(send);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Handler failure", (Throwable)e);
            }
        }));
    }

    @Override
    public void close() {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.close();
        }
    }

    @Override
    public boolean pendingQueueFull() {
        for (RedisConnection conn : this.connections.values()) {
            if (conn == null || !conn.pendingQueueFull()) continue;
            return true;
        }
        return false;
    }

    private String selectEndpoint(int keySlot, boolean readOnly, boolean forceMasterEndpoint) {
        if (keySlot == -1) {
            return this.slots.randomEndPoint(forceMasterEndpoint);
        }
        String[] endpoints = this.slots.endpointsForKey(keySlot);
        if (endpoints == null || endpoints.length == 0) {
            return this.options.getEndpoint();
        }
        return this.selectMasterOrReplicaEndpoint(readOnly, endpoints, forceMasterEndpoint);
    }

    private String selectMasterOrReplicaEndpoint(boolean readOnly, String[] endpoints, boolean forceMasterEndpoint) {
        if (forceMasterEndpoint) {
            return endpoints[0];
        }
        RedisReplicas useReplicas = this.options.getUseReplicas();
        if (readOnly && useReplicas != RedisReplicas.NEVER && endpoints.length > 1) {
            switch (useReplicas) {
                case ALWAYS: {
                    return endpoints[1 + RANDOM.nextInt(endpoints.length - 1)];
                }
                case SHARE: {
                    return endpoints[RANDOM.nextInt(endpoints.length)];
                }
            }
        }
        return endpoints[0];
    }

    private String buildCrossslotFailureMsg(RequestImpl req) {
        return "Keys of command or batch: \"" + req.toString() + "\" targets not all in the same hash slot (CROSSSLOT) and client side resharding is not supported";
    }

    private static /* synthetic */ void lambda$send$1(Promise promise, Command cmd, AsyncResult composite) {
        if (composite.failed()) {
            promise.fail(composite.cause());
        } else {
            promise.complete((Object)REDUCERS.get(cmd).apply(((CompositeFuture)composite.result()).list()));
        }
    }

    private static /* synthetic */ void lambda$send$0(Promise promise, Command cmd, AsyncResult composite) {
        if (composite.failed()) {
            promise.fail(composite.cause());
        } else {
            promise.complete((Object)REDUCERS.get(cmd).apply(((CompositeFuture)composite.result()).list()));
        }
    }
}

