/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.RedisClusterConnection;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.NumberType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class RedisClusterClient
extends BaseRedisClient
implements Redis {
    private final RedisOptions options;

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        RedisClusterConnection.addReducer(command, fn);
    }

    public static void addUnSupportedCommand(Command command, String error) {
        RedisClusterConnection.addUnSupportedCommand(command, error);
    }

    public static void addMasterOnlyCommand(Command command) {
        RedisClusterConnection.addMasterOnlyCommand(command);
    }

    public RedisClusterClient(Vertx vertx, RedisOptions options) {
        super(vertx, options);
        this.options = options;
        if (options.getMaxPoolWaiting() < options.getMaxPoolSize()) {
            throw new IllegalStateException("Invalid options: maxPoolWaiting < maxPoolSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        this.connect(this.options.getEndpoints(), 0, (Handler<AsyncResult<RedisConnection>>)promise);
        return promise.future();
    }

    private void connect(List<String> endpoints, int index, Handler<AsyncResult<RedisConnection>> onConnect) {
        if (index >= endpoints.size()) {
            onConnect.handle((Object)Future.failedFuture((String)"Cannot connect to any of the provided endpoints"));
            return;
        }
        this.connectionManager.getConnection(endpoints.get(index), RedisReplicas.NEVER != this.options.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> this.connect(endpoints, index + 1, onConnect)).onSuccess(conn -> this.getSlots((String)endpoints.get(index), (RedisConnection)conn, (Handler<AsyncResult<Slots>>)((Handler)getSlots -> {
            if (getSlots.failed()) {
                conn.close();
                this.connect(endpoints, index + 1, onConnect);
                return;
            }
            conn.close();
            Slots slots = (Slots)getSlots.result();
            AtomicBoolean failed = new AtomicBoolean(false);
            AtomicInteger counter = new AtomicInteger();
            HashMap connections = new HashMap();
            if (this.options.getMaxPoolSize() < slots.size()) {
                onConnect.handle((Object)Future.failedFuture((String)("RedisOptions maxPoolSize < Cluster size(" + slots.size() + "): The pool is not able to hold all required connections!")));
                return;
            }
            for (String endpoint : slots.endpoints()) {
                this.connectionManager.getConnection(endpoint, RedisReplicas.NEVER != this.options.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
                    failed.set(true);
                    this.connectionComplete(counter, slots, connections, failed, onConnect);
                }).onSuccess(cconn -> {
                    Map map = connections;
                    synchronized (map) {
                        connections.put(endpoint, cconn);
                    }
                    this.connectionComplete(counter, slots, connections, failed, onConnect);
                });
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionComplete(AtomicInteger counter, Slots slots, Map<String, RedisConnection> connections, AtomicBoolean failed, Handler<AsyncResult<RedisConnection>> onConnect) {
        if (counter.incrementAndGet() == slots.endpoints().length) {
            if (failed.get()) {
                Map<String, RedisConnection> map = connections;
                synchronized (map) {
                    for (RedisConnection value : connections.values()) {
                        if (value == null) continue;
                        value.close();
                    }
                }
                onConnect.handle((Object)Future.failedFuture((String)"Failed to connect to all nodes of the cluster"));
            } else {
                onConnect.handle((Object)Future.succeededFuture((Object)new RedisClusterConnection((Vertx)this.vertx, this.options, slots, connections)));
            }
        }
    }

    private void getSlots(String endpoint, RedisConnection conn, Handler<AsyncResult<Slots>> onGetSlots) {
        conn.send(Request.cmd(Command.CLUSTER).arg("SLOTS"), (Handler<AsyncResult<Response>>)((Handler)send -> {
            if (send.failed()) {
                onGetSlots.handle((Object)Future.failedFuture((Throwable)send.cause()));
                return;
            }
            Response reply = (Response)send.result();
            if (reply.size() == 0) {
                onGetSlots.handle((Object)Future.failedFuture((String)"SLOTS No slots available in the cluster."));
                return;
            }
            onGetSlots.handle((Object)Future.succeededFuture((Object)new Slots(endpoint, reply)));
        }));
    }

    static {
        RedisClusterClient.addReducer(Command.MSET, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DEL, list -> NumberType.create(list.stream().mapToLong(Response::toLong).sum()));
        RedisClusterClient.addReducer(Command.MGET, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.KEYS, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.FLUSHDB, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DBSIZE, list -> NumberType.create(list.stream().mapToLong(Response::toLong).sum()));
        Arrays.asList(Command.ASKING, Command.AUTH, Command.BGREWRITEAOF, Command.BGSAVE, Command.CLIENT, Command.COMMAND, Command.CONFIG, Command.DEBUG, Command.DISCARD, Command.HOST, Command.INFO, Command.LASTSAVE, Command.LATENCY, Command.LOLWUT, Command.MEMORY, Command.MODULE, Command.MONITOR, Command.PFDEBUG, Command.PFSELFTEST, Command.PING, Command.READONLY, Command.READWRITE, Command.REPLCONF, Command.REPLICAOF, Command.ROLE, Command.SAVE, Command.SCAN, Command.SCRIPT, Command.SELECT, Command.SHUTDOWN, Command.SLAVEOF, Command.SLOWLOG, Command.SWAPDB, Command.SYNC, Command.SENTINEL).forEach(command -> RedisClusterClient.addUnSupportedCommand(command, null));
        RedisClusterClient.addUnSupportedCommand(Command.FLUSHALL, "RedisClusterClient does not handle command FLUSHALL, use FLUSHDB");
        RedisClusterClient.addMasterOnlyCommand(Command.WAIT);
    }
}

