/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisAPIImpl;
import java.util.List;

@VertxGen
public interface RedisAPI {
    @GenIgnore(value={"permitted-type"})
    public static RedisAPI api(Redis client) {
        return new RedisAPIImpl(client);
    }

    @GenIgnore(value={"permitted-type"})
    public static RedisAPI api(RedisConnection connection) {
        return new RedisAPIImpl(connection);
    }

    public void close();

    @Fluent
    default public RedisAPI acl(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ACL, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> acl(List<String> args) {
        return this.send(Command.ACL, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI append(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.APPEND, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> append(String arg0, String arg1) {
        return this.send(Command.APPEND, arg0, arg1);
    }

    @Fluent
    default public RedisAPI asking(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ASKING, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> asking() {
        return this.send(Command.ASKING, new String[0]);
    }

    @Fluent
    default public RedisAPI auth(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.AUTH, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> auth(List<String> args) {
        return this.send(Command.AUTH, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bgrewriteaof(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BGREWRITEAOF, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bgrewriteaof() {
        return this.send(Command.BGREWRITEAOF, new String[0]);
    }

    @Fluent
    default public RedisAPI bgsave(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BGSAVE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bgsave(List<String> args) {
        return this.send(Command.BGSAVE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bitcount(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITCOUNT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bitcount(List<String> args) {
        return this.send(Command.BITCOUNT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bitfield(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITFIELD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bitfield(List<String> args) {
        return this.send(Command.BITFIELD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bitfieldRo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITFIELD_RO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bitfieldRo(List<String> args) {
        return this.send(Command.BITFIELD_RO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bitop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITOP, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bitop(List<String> args) {
        return this.send(Command.BITOP, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bitpos(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITPOS, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bitpos(List<String> args) {
        return this.send(Command.BITPOS, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI blpop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BLPOP, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> blpop(List<String> args) {
        return this.send(Command.BLPOP, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI brpop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BRPOP, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> brpop(List<String> args) {
        return this.send(Command.BRPOP, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI brpoplpush(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BRPOPLPUSH, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> brpoplpush(String arg0, String arg1, String arg2) {
        return this.send(Command.BRPOPLPUSH, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI bzpopmax(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BZPOPMAX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bzpopmax(List<String> args) {
        return this.send(Command.BZPOPMAX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI bzpopmin(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BZPOPMIN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> bzpopmin(List<String> args) {
        return this.send(Command.BZPOPMIN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI client(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.CLIENT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> client(List<String> args) {
        return this.send(Command.CLIENT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI cluster(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.CLUSTER, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> cluster(List<String> args) {
        return this.send(Command.CLUSTER, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI command(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.COMMAND, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> command(List<String> args) {
        return this.send(Command.COMMAND, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI config(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.CONFIG, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> config(List<String> args) {
        return this.send(Command.CONFIG, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI dbsize(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DBSIZE, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> dbsize() {
        return this.send(Command.DBSIZE, new String[0]);
    }

    @Fluent
    default public RedisAPI debug(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DEBUG, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> debug(List<String> args) {
        return this.send(Command.DEBUG, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI decr(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DECR, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> decr(String arg0) {
        return this.send(Command.DECR, arg0);
    }

    @Fluent
    default public RedisAPI decrby(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DECRBY, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> decrby(String arg0, String arg1) {
        return this.send(Command.DECRBY, arg0, arg1);
    }

    @Fluent
    default public RedisAPI del(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DEL, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> del(List<String> args) {
        return this.send(Command.DEL, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI discard(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DISCARD, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> discard() {
        return this.send(Command.DISCARD, new String[0]);
    }

    @Fluent
    default public RedisAPI dump(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DUMP, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> dump(String arg0) {
        return this.send(Command.DUMP, arg0);
    }

    @Fluent
    default public RedisAPI echo(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ECHO, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> echo(String arg0) {
        return this.send(Command.ECHO, arg0);
    }

    @Fluent
    default public RedisAPI eval(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EVAL, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> eval(List<String> args) {
        return this.send(Command.EVAL, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI evalsha(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EVALSHA, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> evalsha(List<String> args) {
        return this.send(Command.EVALSHA, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI exec(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXEC, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> exec() {
        return this.send(Command.EXEC, new String[0]);
    }

    @Fluent
    default public RedisAPI exists(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXISTS, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> exists(List<String> args) {
        return this.send(Command.EXISTS, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI expire(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXPIRE, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> expire(String arg0, String arg1) {
        return this.send(Command.EXPIRE, arg0, arg1);
    }

    @Fluent
    default public RedisAPI expireat(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXPIREAT, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> expireat(String arg0, String arg1) {
        return this.send(Command.EXPIREAT, arg0, arg1);
    }

    @Fluent
    default public RedisAPI flushall(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.FLUSHALL, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> flushall(List<String> args) {
        return this.send(Command.FLUSHALL, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI flushdb(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.FLUSHDB, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> flushdb(List<String> args) {
        return this.send(Command.FLUSHDB, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI geoadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEOADD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> geoadd(List<String> args) {
        return this.send(Command.GEOADD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI geodist(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEODIST, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> geodist(List<String> args) {
        return this.send(Command.GEODIST, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI geohash(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEOHASH, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> geohash(List<String> args) {
        return this.send(Command.GEOHASH, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI geopos(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEOPOS, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> geopos(List<String> args) {
        return this.send(Command.GEOPOS, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI georadius(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUS, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> georadius(List<String> args) {
        return this.send(Command.GEORADIUS, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI georadiusRo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUS_RO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> georadiusRo(List<String> args) {
        return this.send(Command.GEORADIUS_RO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI georadiusbymember(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUSBYMEMBER, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> georadiusbymember(List<String> args) {
        return this.send(Command.GEORADIUSBYMEMBER, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI georadiusbymemberRo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUSBYMEMBER_RO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> georadiusbymemberRo(List<String> args) {
        return this.send(Command.GEORADIUSBYMEMBER_RO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI get(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GET, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> get(String arg0) {
        return this.send(Command.GET, arg0);
    }

    @Fluent
    default public RedisAPI getbit(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GETBIT, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> getbit(String arg0, String arg1) {
        return this.send(Command.GETBIT, arg0, arg1);
    }

    @Fluent
    default public RedisAPI getrange(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GETRANGE, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> getrange(String arg0, String arg1, String arg2) {
        return this.send(Command.GETRANGE, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI getset(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GETSET, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> getset(String arg0, String arg1) {
        return this.send(Command.GETSET, arg0, arg1);
    }

    @Fluent
    default public RedisAPI hdel(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HDEL, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hdel(List<String> args) {
        return this.send(Command.HDEL, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI hello(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HELLO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hello(List<String> args) {
        return this.send(Command.HELLO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI hexists(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HEXISTS, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hexists(String arg0, String arg1) {
        return this.send(Command.HEXISTS, arg0, arg1);
    }

    @Fluent
    default public RedisAPI hget(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HGET, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hget(String arg0, String arg1) {
        return this.send(Command.HGET, arg0, arg1);
    }

    @Fluent
    default public RedisAPI hgetall(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HGETALL, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hgetall(String arg0) {
        return this.send(Command.HGETALL, arg0);
    }

    @Fluent
    default public RedisAPI hincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HINCRBY, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hincrby(String arg0, String arg1, String arg2) {
        return this.send(Command.HINCRBY, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI hincrbyfloat(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HINCRBYFLOAT, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hincrbyfloat(String arg0, String arg1, String arg2) {
        return this.send(Command.HINCRBYFLOAT, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI hkeys(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HKEYS, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hkeys(String arg0) {
        return this.send(Command.HKEYS, arg0);
    }

    @Fluent
    default public RedisAPI hlen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HLEN, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hlen(String arg0) {
        return this.send(Command.HLEN, arg0);
    }

    @Fluent
    default public RedisAPI hmget(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HMGET, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hmget(List<String> args) {
        return this.send(Command.HMGET, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI hmset(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HMSET, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hmset(List<String> args) {
        return this.send(Command.HMSET, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI host(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HOST, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> host(List<String> args) {
        return this.send(Command.HOST, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI hscan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSCAN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hscan(List<String> args) {
        return this.send(Command.HSCAN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI hset(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSET, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hset(List<String> args) {
        return this.send(Command.HSET, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI hsetnx(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSETNX, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hsetnx(String arg0, String arg1, String arg2) {
        return this.send(Command.HSETNX, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI hstrlen(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSTRLEN, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hstrlen(String arg0, String arg1) {
        return this.send(Command.HSTRLEN, arg0, arg1);
    }

    @Fluent
    default public RedisAPI hvals(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HVALS, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> hvals(String arg0) {
        return this.send(Command.HVALS, arg0);
    }

    @Fluent
    default public RedisAPI incr(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INCR, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> incr(String arg0) {
        return this.send(Command.INCR, arg0);
    }

    @Fluent
    default public RedisAPI incrby(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INCRBY, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> incrby(String arg0, String arg1) {
        return this.send(Command.INCRBY, arg0, arg1);
    }

    @Fluent
    default public RedisAPI incrbyfloat(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INCRBYFLOAT, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> incrbyfloat(String arg0, String arg1) {
        return this.send(Command.INCRBYFLOAT, arg0, arg1);
    }

    @Fluent
    default public RedisAPI info(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INFO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> info(List<String> args) {
        return this.send(Command.INFO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI keys(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.KEYS, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> keys(String arg0) {
        return this.send(Command.KEYS, arg0);
    }

    @Fluent
    default public RedisAPI lastsave(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LASTSAVE, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lastsave() {
        return this.send(Command.LASTSAVE, new String[0]);
    }

    @Fluent
    default public RedisAPI latency(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LATENCY, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> latency(List<String> args) {
        return this.send(Command.LATENCY, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI lindex(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LINDEX, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lindex(String arg0, String arg1) {
        return this.send(Command.LINDEX, arg0, arg1);
    }

    @Fluent
    default public RedisAPI linsert(String arg0, String arg1, String arg2, String arg3, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LINSERT, arg0, arg1, arg2, arg3).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> linsert(String arg0, String arg1, String arg2, String arg3) {
        return this.send(Command.LINSERT, arg0, arg1, arg2, arg3);
    }

    @Fluent
    default public RedisAPI llen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LLEN, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> llen(String arg0) {
        return this.send(Command.LLEN, arg0);
    }

    @Fluent
    default public RedisAPI lolwut(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LOLWUT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lolwut(List<String> args) {
        return this.send(Command.LOLWUT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI lpop(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LPOP, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lpop(String arg0) {
        return this.send(Command.LPOP, arg0);
    }

    @Fluent
    default public RedisAPI lpush(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LPUSH, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lpush(List<String> args) {
        return this.send(Command.LPUSH, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI lpushx(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LPUSHX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lpushx(List<String> args) {
        return this.send(Command.LPUSHX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI lrange(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LRANGE, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lrange(String arg0, String arg1, String arg2) {
        return this.send(Command.LRANGE, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI lrem(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LREM, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lrem(String arg0, String arg1, String arg2) {
        return this.send(Command.LREM, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI lset(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LSET, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> lset(String arg0, String arg1, String arg2) {
        return this.send(Command.LSET, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI ltrim(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LTRIM, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> ltrim(String arg0, String arg1, String arg2) {
        return this.send(Command.LTRIM, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI memory(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MEMORY, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> memory(List<String> args) {
        return this.send(Command.MEMORY, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI mget(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MGET, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> mget(List<String> args) {
        return this.send(Command.MGET, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI migrate(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MIGRATE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> migrate(List<String> args) {
        return this.send(Command.MIGRATE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI module(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MODULE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> module(List<String> args) {
        return this.send(Command.MODULE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI monitor(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MONITOR, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> monitor() {
        return this.send(Command.MONITOR, new String[0]);
    }

    @Fluent
    default public RedisAPI move(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MOVE, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> move(String arg0, String arg1) {
        return this.send(Command.MOVE, arg0, arg1);
    }

    @Fluent
    default public RedisAPI mset(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MSET, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> mset(List<String> args) {
        return this.send(Command.MSET, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI msetnx(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MSETNX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> msetnx(List<String> args) {
        return this.send(Command.MSETNX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI multi(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MULTI, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> multi() {
        return this.send(Command.MULTI, new String[0]);
    }

    @Fluent
    default public RedisAPI object(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.OBJECT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> object(List<String> args) {
        return this.send(Command.OBJECT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI persist(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PERSIST, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> persist(String arg0) {
        return this.send(Command.PERSIST, arg0);
    }

    @Fluent
    default public RedisAPI pexpire(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PEXPIRE, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pexpire(String arg0, String arg1) {
        return this.send(Command.PEXPIRE, arg0, arg1);
    }

    @Fluent
    default public RedisAPI pexpireat(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PEXPIREAT, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pexpireat(String arg0, String arg1) {
        return this.send(Command.PEXPIREAT, arg0, arg1);
    }

    @Fluent
    default public RedisAPI pfadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFADD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pfadd(List<String> args) {
        return this.send(Command.PFADD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI pfcount(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFCOUNT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pfcount(List<String> args) {
        return this.send(Command.PFCOUNT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI pfdebug(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFDEBUG, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pfdebug(List<String> args) {
        return this.send(Command.PFDEBUG, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI pfmerge(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFMERGE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pfmerge(List<String> args) {
        return this.send(Command.PFMERGE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI pfselftest(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFSELFTEST, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pfselftest() {
        return this.send(Command.PFSELFTEST, new String[0]);
    }

    @Fluent
    default public RedisAPI ping(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PING, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> ping(List<String> args) {
        return this.send(Command.PING, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI post(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.POST, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> post(List<String> args) {
        return this.send(Command.POST, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI psetex(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PSETEX, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> psetex(String arg0, String arg1, String arg2) {
        return this.send(Command.PSETEX, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI psubscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PSUBSCRIBE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> psubscribe(List<String> args) {
        return this.send(Command.PSUBSCRIBE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI psync(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PSYNC, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> psync(String arg0, String arg1) {
        return this.send(Command.PSYNC, arg0, arg1);
    }

    @Fluent
    default public RedisAPI pttl(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PTTL, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pttl(String arg0) {
        return this.send(Command.PTTL, arg0);
    }

    @Fluent
    default public RedisAPI publish(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PUBLISH, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> publish(String arg0, String arg1) {
        return this.send(Command.PUBLISH, arg0, arg1);
    }

    @Fluent
    default public RedisAPI pubsub(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PUBSUB, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> pubsub(List<String> args) {
        return this.send(Command.PUBSUB, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI punsubscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PUNSUBSCRIBE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> punsubscribe(List<String> args) {
        return this.send(Command.PUNSUBSCRIBE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI randomkey(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RANDOMKEY, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> randomkey() {
        return this.send(Command.RANDOMKEY, new String[0]);
    }

    @Fluent
    default public RedisAPI readonly(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.READONLY, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> readonly() {
        return this.send(Command.READONLY, new String[0]);
    }

    @Fluent
    default public RedisAPI readwrite(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.READWRITE, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> readwrite() {
        return this.send(Command.READWRITE, new String[0]);
    }

    @Fluent
    default public RedisAPI rename(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RENAME, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> rename(String arg0, String arg1) {
        return this.send(Command.RENAME, arg0, arg1);
    }

    @Fluent
    default public RedisAPI renamenx(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RENAMENX, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> renamenx(String arg0, String arg1) {
        return this.send(Command.RENAMENX, arg0, arg1);
    }

    @Fluent
    default public RedisAPI replconf(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.REPLCONF, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> replconf(List<String> args) {
        return this.send(Command.REPLCONF, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI replicaof(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.REPLICAOF, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> replicaof(String arg0, String arg1) {
        return this.send(Command.REPLICAOF, arg0, arg1);
    }

    @Fluent
    default public RedisAPI restore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RESTORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> restore(List<String> args) {
        return this.send(Command.RESTORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI restoreAsking(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RESTORE_ASKING, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> restoreAsking(List<String> args) {
        return this.send(Command.RESTORE_ASKING, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI role(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ROLE, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> role() {
        return this.send(Command.ROLE, new String[0]);
    }

    @Fluent
    default public RedisAPI rpop(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPOP, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> rpop(String arg0) {
        return this.send(Command.RPOP, arg0);
    }

    @Fluent
    default public RedisAPI rpoplpush(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPOPLPUSH, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> rpoplpush(String arg0, String arg1) {
        return this.send(Command.RPOPLPUSH, arg0, arg1);
    }

    @Fluent
    default public RedisAPI rpush(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPUSH, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> rpush(List<String> args) {
        return this.send(Command.RPUSH, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI rpushx(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPUSHX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> rpushx(List<String> args) {
        return this.send(Command.RPUSHX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SADD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sadd(List<String> args) {
        return this.send(Command.SADD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI save(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SAVE, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> save() {
        return this.send(Command.SAVE, new String[0]);
    }

    @Fluent
    default public RedisAPI scan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SCAN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> scan(List<String> args) {
        return this.send(Command.SCAN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI scard(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SCARD, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> scard(String arg0) {
        return this.send(Command.SCARD, arg0);
    }

    @Fluent
    default public RedisAPI script(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SCRIPT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> script(List<String> args) {
        return this.send(Command.SCRIPT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sdiff(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SDIFF, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sdiff(List<String> args) {
        return this.send(Command.SDIFF, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sdiffstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SDIFFSTORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sdiffstore(List<String> args) {
        return this.send(Command.SDIFFSTORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI select(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SELECT, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> select(String arg0) {
        return this.send(Command.SELECT, arg0);
    }

    @Fluent
    default public RedisAPI set(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SET, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> set(List<String> args) {
        return this.send(Command.SET, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI setbit(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETBIT, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> setbit(String arg0, String arg1, String arg2) {
        return this.send(Command.SETBIT, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI setex(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETEX, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> setex(String arg0, String arg1, String arg2) {
        return this.send(Command.SETEX, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI setnx(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETNX, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> setnx(String arg0, String arg1) {
        return this.send(Command.SETNX, arg0, arg1);
    }

    @Fluent
    default public RedisAPI setrange(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETRANGE, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> setrange(String arg0, String arg1, String arg2) {
        return this.send(Command.SETRANGE, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI shutdown(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SHUTDOWN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> shutdown(List<String> args) {
        return this.send(Command.SHUTDOWN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sinter(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SINTER, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sinter(List<String> args) {
        return this.send(Command.SINTER, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sinterstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SINTERSTORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sinterstore(List<String> args) {
        return this.send(Command.SINTERSTORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sismember(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SISMEMBER, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sismember(String arg0, String arg1) {
        return this.send(Command.SISMEMBER, arg0, arg1);
    }

    @Fluent
    default public RedisAPI slaveof(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SLAVEOF, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> slaveof(String arg0, String arg1) {
        return this.send(Command.SLAVEOF, arg0, arg1);
    }

    @Fluent
    default public RedisAPI slowlog(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SLOWLOG, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> slowlog(List<String> args) {
        return this.send(Command.SLOWLOG, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI smembers(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SMEMBERS, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> smembers(String arg0) {
        return this.send(Command.SMEMBERS, arg0);
    }

    @Fluent
    default public RedisAPI smove(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SMOVE, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> smove(String arg0, String arg1, String arg2) {
        return this.send(Command.SMOVE, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI sort(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SORT, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sort(List<String> args) {
        return this.send(Command.SORT, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI spop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SPOP, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> spop(List<String> args) {
        return this.send(Command.SPOP, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI srandmember(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SRANDMEMBER, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> srandmember(List<String> args) {
        return this.send(Command.SRANDMEMBER, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI srem(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SREM, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> srem(List<String> args) {
        return this.send(Command.SREM, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sscan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SSCAN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sscan(List<String> args) {
        return this.send(Command.SSCAN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI stralgo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.STRALGO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> stralgo(List<String> args) {
        return this.send(Command.STRALGO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI strlen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.STRLEN, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> strlen(String arg0) {
        return this.send(Command.STRLEN, arg0);
    }

    @Fluent
    default public RedisAPI subscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUBSCRIBE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> subscribe(List<String> args) {
        return this.send(Command.SUBSCRIBE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI substr(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUBSTR, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> substr(String arg0, String arg1, String arg2) {
        return this.send(Command.SUBSTR, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI sunion(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUNION, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sunion(List<String> args) {
        return this.send(Command.SUNION, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI sunionstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUNIONSTORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sunionstore(List<String> args) {
        return this.send(Command.SUNIONSTORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI swapdb(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SWAPDB, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> swapdb(String arg0, String arg1) {
        return this.send(Command.SWAPDB, arg0, arg1);
    }

    @Fluent
    default public RedisAPI sync(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SYNC, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> sync() {
        return this.send(Command.SYNC, new String[0]);
    }

    @Fluent
    default public RedisAPI time(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TIME, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> time() {
        return this.send(Command.TIME, new String[0]);
    }

    @Fluent
    default public RedisAPI touch(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TOUCH, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> touch(List<String> args) {
        return this.send(Command.TOUCH, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI ttl(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TTL, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> ttl(String arg0) {
        return this.send(Command.TTL, arg0);
    }

    @Fluent
    default public RedisAPI type(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TYPE, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> type(String arg0) {
        return this.send(Command.TYPE, arg0);
    }

    @Fluent
    default public RedisAPI unlink(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.UNLINK, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> unlink(List<String> args) {
        return this.send(Command.UNLINK, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI unsubscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.UNSUBSCRIBE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> unsubscribe(List<String> args) {
        return this.send(Command.UNSUBSCRIBE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI unwatch(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.UNWATCH, new String[0]).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> unwatch() {
        return this.send(Command.UNWATCH, new String[0]);
    }

    @Fluent
    default public RedisAPI wait(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.WAIT, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> wait(String arg0, String arg1) {
        return this.send(Command.WAIT, arg0, arg1);
    }

    @Fluent
    default public RedisAPI watch(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.WATCH, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> watch(List<String> args) {
        return this.send(Command.WATCH, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xack(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XACK, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xack(List<String> args) {
        return this.send(Command.XACK, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XADD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xadd(List<String> args) {
        return this.send(Command.XADD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xclaim(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XCLAIM, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xclaim(List<String> args) {
        return this.send(Command.XCLAIM, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xdel(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XDEL, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xdel(List<String> args) {
        return this.send(Command.XDEL, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xgroup(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XGROUP, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xgroup(List<String> args) {
        return this.send(Command.XGROUP, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xinfo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XINFO, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xinfo(List<String> args) {
        return this.send(Command.XINFO, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xlen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XLEN, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xlen(String arg0) {
        return this.send(Command.XLEN, arg0);
    }

    @Fluent
    default public RedisAPI xpending(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XPENDING, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xpending(List<String> args) {
        return this.send(Command.XPENDING, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XRANGE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xrange(List<String> args) {
        return this.send(Command.XRANGE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xread(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XREAD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xread(List<String> args) {
        return this.send(Command.XREAD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xreadgroup(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XREADGROUP, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xreadgroup(List<String> args) {
        return this.send(Command.XREADGROUP, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xrevrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XREVRANGE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xrevrange(List<String> args) {
        return this.send(Command.XREVRANGE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI xsetid(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XSETID, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xsetid(String arg0, String arg1) {
        return this.send(Command.XSETID, arg0, arg1);
    }

    @Fluent
    default public RedisAPI xtrim(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XTRIM, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> xtrim(List<String> args) {
        return this.send(Command.XTRIM, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZADD, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zadd(List<String> args) {
        return this.send(Command.ZADD, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zcard(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZCARD, arg0).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zcard(String arg0) {
        return this.send(Command.ZCARD, arg0);
    }

    @Fluent
    default public RedisAPI zcount(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZCOUNT, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zcount(String arg0, String arg1, String arg2) {
        return this.send(Command.ZCOUNT, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI zincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZINCRBY, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zincrby(String arg0, String arg1, String arg2) {
        return this.send(Command.ZINCRBY, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI zinterstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZINTERSTORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zinterstore(List<String> args) {
        return this.send(Command.ZINTERSTORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zlexcount(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZLEXCOUNT, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zlexcount(String arg0, String arg1, String arg2) {
        return this.send(Command.ZLEXCOUNT, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI zpopmax(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZPOPMAX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zpopmax(List<String> args) {
        return this.send(Command.ZPOPMAX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zpopmin(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZPOPMIN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zpopmin(List<String> args) {
        return this.send(Command.ZPOPMIN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANGE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrange(List<String> args) {
        return this.send(Command.ZRANGE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrangebylex(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANGEBYLEX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrangebylex(List<String> args) {
        return this.send(Command.ZRANGEBYLEX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrangebyscore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANGEBYSCORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrangebyscore(List<String> args) {
        return this.send(Command.ZRANGEBYSCORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrank(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANK, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrank(String arg0, String arg1) {
        return this.send(Command.ZRANK, arg0, arg1);
    }

    @Fluent
    default public RedisAPI zrem(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREM, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrem(List<String> args) {
        return this.send(Command.ZREM, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zremrangebylex(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREMRANGEBYLEX, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zremrangebylex(String arg0, String arg1, String arg2) {
        return this.send(Command.ZREMRANGEBYLEX, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI zremrangebyrank(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREMRANGEBYRANK, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zremrangebyrank(String arg0, String arg1, String arg2) {
        return this.send(Command.ZREMRANGEBYRANK, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI zremrangebyscore(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREMRANGEBYSCORE, arg0, arg1, arg2).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zremrangebyscore(String arg0, String arg1, String arg2) {
        return this.send(Command.ZREMRANGEBYSCORE, arg0, arg1, arg2);
    }

    @Fluent
    default public RedisAPI zrevrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANGE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrevrange(List<String> args) {
        return this.send(Command.ZREVRANGE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrevrangebylex(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANGEBYLEX, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrevrangebylex(List<String> args) {
        return this.send(Command.ZREVRANGEBYLEX, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrevrangebyscore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANGEBYSCORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrevrangebyscore(List<String> args) {
        return this.send(Command.ZREVRANGEBYSCORE, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zrevrank(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANK, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zrevrank(String arg0, String arg1) {
        return this.send(Command.ZREVRANK, arg0, arg1);
    }

    @Fluent
    default public RedisAPI zscan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZSCAN, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zscan(List<String> args) {
        return this.send(Command.ZSCAN, args.toArray(new String[0]));
    }

    @Fluent
    default public RedisAPI zscore(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZSCORE, arg0, arg1).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zscore(String arg0, String arg1) {
        return this.send(Command.ZSCORE, arg0, arg1);
    }

    @Fluent
    default public RedisAPI zunionstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZUNIONSTORE, args.toArray(new String[0])).onComplete(handler);
        return this;
    }

    default public Future<@Nullable Response> zunionstore(List<String> args) {
        return this.send(Command.ZUNIONSTORE, args.toArray(new String[0]));
    }

    @GenIgnore
    public Future<@Nullable Response> send(Command var1, String ... var2);
}

