/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.Handler;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.impl.ProtonDeliveryImpl;
import io.vertx.proton.impl.ProtonLinkImpl;
import io.vertx.proton.impl.ProtonReadableBufferImpl;
import io.vertx.proton.impl.ProtonWritableBufferImpl;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class ProtonSenderImpl
extends ProtonLinkImpl<ProtonSender>
implements ProtonSender {
    private Handler<ProtonSender> drainHandler;
    private boolean anonymousSender;
    private boolean autoSettle = true;
    private int tag = 1;
    private boolean autoDrained = true;

    public ProtonSenderImpl(Sender sender) {
        super((Link)sender);
    }

    private Sender sender() {
        return (Sender)this.link;
    }

    @Override
    public ProtonDelivery send(Message message) {
        return this.send(message, null);
    }

    @Override
    public ProtonDelivery send(Message message, Handler<ProtonDelivery> onUpdated) {
        return this.send(this.generateTag(), message, onUpdated);
    }

    private byte[] generateTag() {
        int value = this.tag++;
        byte[] binary = new byte[4];
        ProtonSenderImpl.setInt(binary, value);
        return binary;
    }

    private static void setInt(byte[] binary, int value) {
        binary[0] = (byte)(value >>> 24);
        binary[1] = (byte)(value >>> 16);
        binary[2] = (byte)(value >>> 8);
        binary[3] = (byte)value;
    }

    @Override
    public ProtonDelivery send(byte[] tag, Message message) {
        return this.send(tag, message, null);
    }

    @Override
    public ProtonDelivery send(byte[] tag, Message message, Handler<ProtonDelivery> onUpdated) {
        if (this.anonymousSender && message.getAddress() == null) {
            throw new IllegalArgumentException("Message must have an address when using anonymous sender.");
        }
        Delivery delivery = this.sender().delivery(tag);
        ProtonWritableBufferImpl buffer = new ProtonWritableBufferImpl();
        MessageImpl msg = (MessageImpl)message;
        msg.encode((WritableBuffer)buffer);
        ProtonReadableBufferImpl encoded = new ProtonReadableBufferImpl(buffer.getBuffer());
        this.sender().sendNoCopy((ReadableBuffer)encoded);
        if (this.link.getSenderSettleMode() == SenderSettleMode.SETTLED) {
            delivery.settle();
        }
        this.sender().advance();
        ProtonDeliveryImpl protonDeliveryImpl = new ProtonDeliveryImpl(delivery);
        if (onUpdated != null) {
            protonDeliveryImpl.setAutoSettle(this.autoSettle);
            protonDeliveryImpl.handler(onUpdated);
        } else {
            protonDeliveryImpl.setAutoSettle(true);
        }
        this.getSession().getConnectionImpl().flush();
        return protonDeliveryImpl;
    }

    @Override
    public boolean isAutoSettle() {
        return this.autoSettle;
    }

    @Override
    public ProtonSender setAutoSettle(boolean autoSettle) {
        this.autoSettle = autoSettle;
        return this;
    }

    boolean isAnonymousSender() {
        return this.anonymousSender;
    }

    void setAnonymousSender(boolean anonymousSender) {
        this.anonymousSender = anonymousSender;
    }

    @Override
    protected ProtonSenderImpl self() {
        return this;
    }

    @Override
    public boolean sendQueueFull() {
        return this.link.getRemoteCredit() <= 0;
    }

    @Override
    public ProtonSender sendQueueDrainHandler(Handler<ProtonSender> drainHandler) {
        this.drainHandler = drainHandler;
        this.handleLinkFlow();
        return this;
    }

    @Override
    void handleLinkFlow() {
        if (this.link.getRemoteCredit() > 0 && this.drainHandler != null) {
            this.drainHandler.handle((Object)this);
        }
        if (this.autoDrained && this.getDrain()) {
            this.drained();
        }
    }

    @Override
    public boolean isAutoDrained() {
        return this.autoDrained;
    }

    @Override
    public ProtonSender setAutoDrained(boolean autoDrained) {
        this.autoDrained = autoDrained;
        return this;
    }

    @Override
    public int drained() {
        return super.drained();
    }

    @Override
    public String getRemoteAddress() {
        Target remoteTarget = this.getRemoteTarget();
        return remoteTarget == null ? null : remoteTarget.getAddress();
    }
}

