/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.core.Completable;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgDecoder;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.sqlclient.ClosedConnectionException;
import io.vertx.sqlclient.internal.command.CommandBase;
import java.util.ArrayDeque;
import java.util.Iterator;

public class PgCodec
extends CombinedChannelDuplexHandler<PgDecoder, PgEncoder> {
    private final ArrayDeque<PgCommandCodec<?, ?>> inflight = new ArrayDeque();
    private final PgDecoder decoder = new PgDecoder(this);
    private final PgEncoder encoder;
    private ChannelHandlerContext chctx;
    private Throwable failure;

    public PgCodec(boolean useLayer7Proxy) {
        this.encoder = new PgEncoder(useLayer7Proxy, this);
        this.init((ChannelInboundHandler)this.decoder, (ChannelOutboundHandler)this.encoder);
    }

    boolean add(PgCommandCodec<?, ?> codec) {
        if (this.failure == null) {
            codec.decoder = this.decoder;
            this.inflight.add(codec);
            return true;
        }
        this.fail(codec, this.failure);
        return false;
    }

    PgCommandCodec<?, ?> peek() {
        return this.inflight.peek();
    }

    PgCommandCodec<?, ?> poll() {
        return this.inflight.poll();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
        super.handlerAdded(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.fail(cause);
        super.exceptionCaught(ctx, cause);
    }

    private void fail(Throwable cause) {
        if (this.failure == null) {
            this.failure = cause;
            Iterator<PgCommandCodec<?, ?>> it = this.inflight.iterator();
            while (it.hasNext()) {
                PgCommandCodec<?, ?> cmdCodec = it.next();
                it.remove();
                this.fail(cmdCodec, cause);
            }
        }
    }

    private void fail(PgCommandCodec<?, ?> codec, Throwable cause) {
        Completable handler = ((CommandBase)codec.cmd).handler;
        if (handler != null) {
            handler.complete(null, cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.fail((Throwable)ClosedConnectionException.INSTANCE);
        super.channelInactive(ctx);
    }
}

