/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Cidr;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Inet;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Money;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.pgclient.impl.codec.ParamExtractor;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.internal.TupleInternal;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public enum DataType {
    BOOL(16, true, Boolean.class, JDBCType.BOOLEAN, null, Tuple::getBoolean, 1),
    BOOL_ARRAY(1000, true, Boolean[].class, JDBCType.BOOLEAN, null, Tuple::getArrayOfBooleans, 1),
    INT2(21, true, Short.class, Number.class, JDBCType.SMALLINT, Tuple::getShort, null, 2),
    INT2_ARRAY(1005, true, Short[].class, Number[].class, JDBCType.SMALLINT, Tuple::getArrayOfShorts, null, 2),
    INT4(23, true, Integer.class, Number.class, JDBCType.INTEGER, Tuple::getInteger, null, 4),
    INT4_ARRAY(1007, true, Integer[].class, Number[].class, JDBCType.INTEGER, Tuple::getArrayOfIntegers, null, 4),
    INT8(20, true, Long.class, Number.class, JDBCType.BIGINT, Tuple::getLong, null, 8),
    INT8_ARRAY(1016, true, Long[].class, Number[].class, JDBCType.BIGINT, Tuple::getArrayOfLongs, null, 8),
    FLOAT4(700, true, Float.class, Number.class, JDBCType.REAL, Tuple::getFloat, null, 4),
    FLOAT4_ARRAY(1021, true, Float[].class, Number[].class, JDBCType.REAL, Tuple::getArrayOfFloats, null, 4),
    FLOAT8(701, true, Double.class, Number.class, JDBCType.DOUBLE, Tuple::getDouble, null, 8),
    FLOAT8_ARRAY(1022, true, Double[].class, Number[].class, JDBCType.DOUBLE, Tuple::getArrayOfDoubles, null, 8),
    NUMERIC(1700, false, Numeric.class, Number.class, JDBCType.NUMERIC, Tuple::getNumeric, ParamExtractor::prepareNumeric, -2),
    NUMERIC_ARRAY(1231, false, Numeric[].class, Number[].class, JDBCType.NUMERIC, Tuple::getArrayOfNumerics, ParamExtractor::prepareNumeric, -7),
    MONEY(790, true, Money.class, null, 8),
    MONEY_ARRAY(791, true, Money[].class, null, 8),
    BIT(1560, true, Object.class, JDBCType.BIT, 0),
    BIT_ARRAY(1561, true, Object[].class, JDBCType.BIT, 0),
    VARBIT(1562, true, Object.class, JDBCType.OTHER, 0),
    VARBIT_ARRAY(1563, true, Object[].class, JDBCType.BIT, 0),
    CHAR(18, true, String.class, JDBCType.BIT, null, Tuple::getString, -1),
    CHAR_ARRAY(1002, true, String[].class, JDBCType.CHAR, null, Tuple::getArrayOfStrings, -1),
    VARCHAR(1043, true, String.class, JDBCType.VARCHAR, null, Tuple::getString, -1),
    VARCHAR_ARRAY(1015, true, String[].class, JDBCType.VARCHAR, null, Tuple::getArrayOfStrings, -1),
    BPCHAR(1042, true, String.class, JDBCType.VARCHAR, null, Tuple::getString, -1),
    BPCHAR_ARRAY(1014, true, String[].class, JDBCType.VARCHAR, null, Tuple::getArrayOfStrings, -1),
    TEXT(25, true, String.class, JDBCType.LONGVARCHAR, null, Tuple::getString, -1),
    TEXT_ARRAY(1009, true, String[].class, JDBCType.LONGVARCHAR, null, Tuple::getArrayOfStrings, -1),
    NAME(19, true, String.class, JDBCType.VARCHAR, null, Tuple::getString, -1),
    NAME_ARRAY(1003, true, String[].class, JDBCType.VARCHAR, null, Tuple::getArrayOfStrings, -1),
    DATE(1082, true, LocalDate.class, JDBCType.DATE, null, Tuple::getLocalDate, 4),
    DATE_ARRAY(1182, true, LocalDate[].class, JDBCType.DATE, null, Tuple::getArrayOfLocalDates, 4),
    TIME(1083, true, LocalTime.class, JDBCType.TIME, null, Tuple::getLocalTime, 8),
    TIME_ARRAY(1183, true, LocalTime[].class, JDBCType.TIME, null, Tuple::getArrayOfLocalTimes, 8),
    TIMETZ(1266, true, OffsetTime.class, JDBCType.TIME_WITH_TIMEZONE, null, Tuple::getOffsetTime, 12),
    TIMETZ_ARRAY(1270, true, OffsetTime[].class, JDBCType.TIME_WITH_TIMEZONE, null, Tuple::getArrayOfOffsetTimes, 12),
    TIMESTAMP(1114, true, LocalDateTime.class, JDBCType.TIMESTAMP, null, Tuple::getLocalDateTime, 8),
    TIMESTAMP_ARRAY(1115, true, LocalDateTime[].class, JDBCType.TIMESTAMP, null, Tuple::getArrayOfLocalDateTimes, 8),
    TIMESTAMPTZ(1184, true, OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE, null, Tuple::getOffsetDateTime, 8),
    TIMESTAMPTZ_ARRAY(1185, true, OffsetDateTime[].class, JDBCType.TIMESTAMP_WITH_TIMEZONE, null, Tuple::getArrayOfOffsetDateTimes, 8),
    INTERVAL(1186, true, Interval.class, JDBCType.DATE, 16),
    INTERVAL_ARRAY(1187, true, Interval[].class, JDBCType.DATE, 16),
    BYTEA(17, true, Buffer.class, JDBCType.BINARY, null, Tuple::getBuffer, -3),
    BYTEA_ARRAY(1001, true, Buffer[].class, JDBCType.BINARY, null, Tuple::getArrayOfBuffers, -3),
    MACADDR(829, true, Object.class, JDBCType.OTHER, 0),
    INET(869, true, Inet.class, JDBCType.OTHER, -10),
    INET_ARRAY(1041, true, Inet[].class, JDBCType.OTHER, -10),
    CIDR(650, true, Cidr.class, JDBCType.OTHER, -9),
    MACADDR8(774, true, Object[].class, JDBCType.OTHER, 0),
    UUID(2950, true, UUID.class, JDBCType.OTHER, null, Tuple::getUUID, 16),
    UUID_ARRAY(2951, true, UUID[].class, JDBCType.OTHER, null, Tuple::getArrayOfUUIDs, 16),
    JSON(114, true, Object.class, JDBCType.OTHER, ParamExtractor::prepareJson, Tuple::getJson, -1),
    JSON_ARRAY(199, true, Object[].class, JDBCType.OTHER, ParamExtractor::prepareJson, Tuple::getArrayOfJsons, -1),
    JSONB(3802, true, Object.class, JDBCType.OTHER, ParamExtractor::prepareJson, Tuple::getJson, -8),
    JSONB_ARRAY(3807, true, Object[].class, JDBCType.OTHER, ParamExtractor::prepareJson, Tuple::getArrayOfJsons, -8),
    XML(142, true, Object.class, JDBCType.OTHER, 0),
    XML_ARRAY(143, true, Object[].class, JDBCType.OTHER, 0),
    POINT(600, true, Point.class, JDBCType.OTHER, 16),
    POINT_ARRAY(1017, true, Point[].class, JDBCType.OTHER, 16),
    LINE(628, true, Line.class, JDBCType.OTHER, 24),
    LINE_ARRAY(629, true, Line[].class, JDBCType.OTHER, 24),
    LSEG(601, true, LineSegment.class, JDBCType.OTHER, 32),
    LSEG_ARRAY(1018, true, LineSegment[].class, JDBCType.OTHER, 32),
    BOX(603, true, Box.class, JDBCType.OTHER, 32),
    BOX_ARRAY(1020, true, Box[].class, JDBCType.OTHER, 32),
    PATH(602, true, Path.class, JDBCType.OTHER, -5),
    PATH_ARRAY(1019, true, Path[].class, JDBCType.OTHER, -5),
    POLYGON(604, true, Polygon.class, JDBCType.OTHER, -4),
    POLYGON_ARRAY(1027, true, Polygon[].class, JDBCType.OTHER, -4),
    CIRCLE(718, true, Circle.class, JDBCType.OTHER, 24),
    CIRCLE_ARRAY(719, true, Circle[].class, JDBCType.OTHER, 24),
    HSTORE(33670, true, Object.class, JDBCType.OTHER, 0),
    OID(26, true, Object.class, JDBCType.OTHER, 0),
    OID_ARRAY(1028, true, Object[].class, JDBCType.OTHER, 0),
    VOID(2278, true, Object.class, JDBCType.OTHER, 0),
    UNKNOWN(705, false, String.class, JDBCType.OTHER, ParamExtractor::prepareUnknown, ParamExtractor::extractUnknownType, -6),
    TS_VECTOR(3614, false, String.class, JDBCType.OTHER, 0),
    TS_VECTOR_ARRAY(3643, false, String[].class, JDBCType.OTHER, 0),
    TS_QUERY(3615, false, String.class, JDBCType.OTHER, 0),
    TS_QUERY_ARRAY(3645, false, String[].class, JDBCType.OTHER, 0);

    private static final Logger logger;
    private static final IntObjectMap<DataType> oidToDataType;
    private static final Map<Class<?>, DataType> encodingTypeToDataType;
    final int id;
    final boolean array;
    final boolean supportsBinary;
    final Class<?> encodingType;
    final Class<?> decodingType;
    final JDBCType jdbcType;
    final ParamExtractor<?> paramExtractor;
    final Function<Object, Object> preEncoder;
    final int lengthEstimator;

    private <T> DataType(int id, boolean supportsBinary, Class<T> type, JDBCType jdbcType, Function<Object, Object> preEncoder, ParamExtractor<T> paramExtractor, int lengthEstimator) {
        this(id, supportsBinary, type, type, jdbcType, paramExtractor, preEncoder, lengthEstimator);
    }

    private <T> DataType(int id, boolean supportsBinary, Class<T> type, JDBCType jdbcType, int lengthEstimator) {
        this(id, supportsBinary, type, type, jdbcType, null, null, lengthEstimator);
    }

    private <T> DataType(int id, boolean supportsBinary, Class<T> encodingType, Class<?> decodingType, JDBCType jdbcType, ParamExtractor<T> paramExtractor, Function<Object, Object> preEncoder, int lengthEstimator) {
        this.id = id;
        this.supportsBinary = supportsBinary;
        this.encodingType = Objects.requireNonNull(encodingType);
        this.decodingType = decodingType;
        this.jdbcType = jdbcType;
        this.array = decodingType.isArray();
        this.paramExtractor = paramExtractor != null ? paramExtractor : new DefaultParamExtractor<T>(encodingType);
        this.preEncoder = preEncoder;
        this.lengthEstimator = lengthEstimator;
    }

    static DataType valueOf(int oid) {
        DataType value = (DataType)((Object)oidToDataType.get(oid));
        if (value == null) {
            logger.debug((Object)("Postgres type OID=" + oid + " not handled - using unknown type instead"));
            return UNKNOWN;
        }
        return value;
    }

    static DataType lookup(Class<?> type) {
        DataType dataType = encodingTypeToDataType.get(type);
        if (dataType == null) {
            if (Buffer.class.isAssignableFrom(type)) {
                return BYTEA;
            }
            dataType = UNKNOWN;
        }
        return dataType;
    }

    static {
        logger = LoggerFactory.getLogger(DataType.class);
        oidToDataType = new IntObjectHashMap();
        encodingTypeToDataType = new HashMap();
        for (DataType dataType : DataType.values()) {
            oidToDataType.put(dataType.id, (Object)dataType);
        }
        encodingTypeToDataType.put(String.class, VARCHAR);
        encodingTypeToDataType.put(String[].class, VARCHAR_ARRAY);
        encodingTypeToDataType.put(Boolean.class, BOOL);
        encodingTypeToDataType.put(Boolean[].class, BOOL_ARRAY);
        encodingTypeToDataType.put(Short.class, INT2);
        encodingTypeToDataType.put(Short[].class, INT2_ARRAY);
        encodingTypeToDataType.put(Integer.class, INT4);
        encodingTypeToDataType.put(Integer[].class, INT4_ARRAY);
        encodingTypeToDataType.put(Long.class, INT8);
        encodingTypeToDataType.put(Long[].class, INT8_ARRAY);
        encodingTypeToDataType.put(Float.class, FLOAT4);
        encodingTypeToDataType.put(Float[].class, FLOAT4_ARRAY);
        encodingTypeToDataType.put(Double.class, FLOAT8);
        encodingTypeToDataType.put(Double[].class, FLOAT8_ARRAY);
        encodingTypeToDataType.put(LocalDate.class, DATE);
        encodingTypeToDataType.put(LocalDate[].class, DATE_ARRAY);
        encodingTypeToDataType.put(LocalDateTime.class, TIMESTAMP);
        encodingTypeToDataType.put(LocalDateTime[].class, TIMESTAMP_ARRAY);
        encodingTypeToDataType.put(OffsetDateTime.class, TIMESTAMPTZ);
        encodingTypeToDataType.put(OffsetDateTime[].class, TIMESTAMPTZ_ARRAY);
        encodingTypeToDataType.put(Interval.class, INTERVAL);
        encodingTypeToDataType.put(Interval[].class, INTERVAL_ARRAY);
        encodingTypeToDataType.put(Buffer[].class, BYTEA_ARRAY);
        encodingTypeToDataType.put(UUID.class, UUID);
        encodingTypeToDataType.put(UUID[].class, UUID_ARRAY);
        encodingTypeToDataType.put(JsonObject.class, JSON);
        encodingTypeToDataType.put(JsonObject[].class, JSON_ARRAY);
        encodingTypeToDataType.put(JsonArray.class, JSON);
        encodingTypeToDataType.put(JsonArray[].class, JSON_ARRAY);
        encodingTypeToDataType.put(Point.class, POINT);
        encodingTypeToDataType.put(Point[].class, POINT_ARRAY);
        encodingTypeToDataType.put(Line.class, LINE);
        encodingTypeToDataType.put(Line[].class, LINE_ARRAY);
        encodingTypeToDataType.put(LineSegment.class, LSEG);
        encodingTypeToDataType.put(LineSegment[].class, LSEG_ARRAY);
        encodingTypeToDataType.put(Box.class, BOX);
        encodingTypeToDataType.put(Box[].class, BOX_ARRAY);
        encodingTypeToDataType.put(Path.class, PATH);
        encodingTypeToDataType.put(Path[].class, PATH_ARRAY);
        encodingTypeToDataType.put(Polygon.class, POLYGON);
        encodingTypeToDataType.put(Polygon[].class, POLYGON_ARRAY);
        encodingTypeToDataType.put(Circle.class, CIRCLE);
        encodingTypeToDataType.put(Circle[].class, CIRCLE_ARRAY);
    }

    private static class DefaultParamExtractor<T>
    implements ParamExtractor<T> {
        static final RuntimeException FAILURE = new VertxException("ignored", true);
        final Class<T> encodingType;

        DefaultParamExtractor(Class<T> encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        public T get(TupleInternal tuple, int idx) {
            Object value = tuple.getValue(idx);
            if (value == null) {
                return null;
            }
            if (this.encodingType.isAssignableFrom(value.getClass())) {
                return this.encodingType.cast(value);
            }
            throw FAILURE;
        }
    }
}

