/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.impl.InitiateSslHandler;
import io.vertx.pgclient.impl.PgDatabaseMetadata;
import io.vertx.pgclient.impl.codec.NoticeResponse;
import io.vertx.pgclient.impl.codec.PgCodec;
import io.vertx.pgclient.impl.codec.TxFailedEvent;
import io.vertx.sqlclient.impl.Notification;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.InitCommand;
import io.vertx.sqlclient.internal.command.QueryCommandBase;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import io.vertx.sqlclient.internal.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

public class PgSocketConnection
extends SocketConnectionBase {
    private PgCodec codec;
    private final boolean useLayer7Proxy;
    public int processId;
    public int secretKey;
    public PgDatabaseMetadata dbMetaData;
    private PgConnectOptions connectOptions;

    public PgSocketConnection(NetSocketInternal socket, ClientMetrics metrics, PgConnectOptions connectOptions, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, boolean useLayer7Proxy, ContextInternal context) {
        super(socket, metrics, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
        this.connectOptions = connectOptions;
        this.useLayer7Proxy = useLayer7Proxy;
    }

    protected PgConnectOptions connectOptions() {
        return this.connectOptions;
    }

    public void init() {
        this.codec = new PgCodec(this.useLayer7Proxy);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    Future<Connection> sendStartupMessage(String username, String password, String database, Map<String, String> properties) {
        InitCommand cmd = new InitCommand((Connection)this, username, password, database, properties);
        PromiseInternal promise = this.context.promise();
        this.schedule((CommandBase)cmd, (Completable)promise);
        return promise.future();
    }

    Future<Void> sendCancelRequestMessage(int processId, int secretKey) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.appendInt(16);
        buffer.appendInt(80877102);
        buffer.appendInt(processId);
        buffer.appendInt(secretKey);
        return this.socket.write((Object)buffer).andThen(ar -> {
            if (ar.succeeded() && this.status == SocketConnectionBase.Status.CONNECTED) {
                this.status = SocketConnectionBase.Status.CLOSING;
                this.socket.close();
            }
        });
    }

    protected void handleMessage(Object msg) {
        super.handleMessage(msg);
        if (msg instanceof Notification || msg instanceof TxFailedEvent || msg instanceof NoticeResponse) {
            this.handleEvent(msg);
        }
    }

    protected void handleException(Throwable t) {
        if (t instanceof PgException) {
            this.reportException(t);
        } else {
            super.handleException(t);
        }
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getSecretKey() {
        return this.secretKey;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.dbMetaData;
    }

    void upgradeToSSLConnection(ClientSSLOptions sslOptions, Handler<AsyncResult<Void>> completionHandler) {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        Promise upgradePromise = Promise.promise();
        upgradePromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                Throwable cause = ar.cause();
                if (cause instanceof DecoderException) {
                    DecoderException err = (DecoderException)cause;
                    cause = err.getCause();
                }
                completionHandler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        });
        pipeline.addBefore("handler", "initiate-ssl-handler", (ChannelHandler)new InitiateSslHandler(this, sslOptions, (Promise<Void>)upgradePromise));
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Completable<R> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand tx = (TxCommand)cmd;
            SimpleQueryCommand cmd2 = new SimpleQueryCommand(tx.kind.sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
            super.doSchedule((CommandBase)cmd2, (res, err) -> handler.complete(tx.result, err));
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    public boolean isIndeterminatePreparedStatementError(Throwable error) {
        if (error instanceof PgException) {
            String sqlState = ((PgException)((Object)error)).getSqlState();
            return "42P18".equals(sqlState) || "42804".equals(sqlState) || "42P08".equals(sqlState);
        }
        return false;
    }

    public String system() {
        return "postgresql";
    }
}

