/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.datatype;

import io.netty.buffer.ByteBuf;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.mysqlclient.data.spatial.Geometry;
import io.vertx.mysqlclient.data.spatial.GeometryCollection;
import io.vertx.mysqlclient.data.spatial.LineString;
import io.vertx.mysqlclient.data.spatial.MultiLineString;
import io.vertx.mysqlclient.data.spatial.MultiPoint;
import io.vertx.mysqlclient.data.spatial.MultiPolygon;
import io.vertx.mysqlclient.data.spatial.Point;
import io.vertx.mysqlclient.data.spatial.Polygon;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import java.util.ArrayList;

public class GeometryWkbFormatCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryWkbFormatCodec.class);
    private static final byte WKB_BYTE_ORDER_LITTLE_ENDIAN = 1;
    private static final int WKB_GEOMETRY_TYPE_POINT = 1;
    private static final int WKB_GEOMETRY_TYPE_LINESTRING = 2;
    private static final int WKB_GEOMETRY_TYPE_POLYGON = 3;
    private static final int WKB_GEOMETRY_TYPE_MULTIPOINT = 4;
    private static final int WKB_GEOMETRY_TYPE_MULTILINESTRING = 5;
    private static final int WKB_GEOMETRY_TYPE_MULTIPOLYGON = 6;
    private static final int WKB_GEOMETRY_TYPE_GEOMETRYCOLLECTION = 7;

    public static Object decodeMySQLGeometry(ByteBuf buffer) {
        long srid = buffer.readUnsignedIntLE();
        buffer.readByte();
        int type = buffer.readIntLE();
        return GeometryWkbFormatCodec.decodeWkbFormatGeometry(buffer, srid, type);
    }

    public static void encodeGeometryToMySQLBlob(ByteBuf buffer, Geometry geometry) {
        if (geometry instanceof Point) {
            GeometryWkbFormatCodec.encodePointToBlob(buffer, (Point)geometry);
        } else if (geometry instanceof LineString) {
            GeometryWkbFormatCodec.encodeLineStringToBlob(buffer, (LineString)geometry);
        } else if (geometry instanceof Polygon) {
            GeometryWkbFormatCodec.encodePolygonToBlob(buffer, (Polygon)geometry);
        } else if (geometry instanceof MultiPoint) {
            GeometryWkbFormatCodec.encodeMultiPointToBlob(buffer, (MultiPoint)geometry);
        } else if (geometry instanceof MultiLineString) {
            GeometryWkbFormatCodec.encodeMultiLineStringToBlob(buffer, (MultiLineString)geometry);
        } else if (geometry instanceof MultiPolygon) {
            GeometryWkbFormatCodec.encodeMultiPolygonToBlob(buffer, (MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            GeometryWkbFormatCodec.encodeGeometryCollectionToBlob(buffer, (GeometryCollection)geometry);
        } else {
            LOGGER.error((Object)String.format("Error when encoding unknown geometry type, type=[%s]", geometry.getClass().getName()));
        }
    }

    private static Object decodeWkbFormatGeometry(ByteBuf buffer, long srid, int type) {
        switch (type) {
            case 1: {
                return GeometryWkbFormatCodec.decodePoint(buffer, srid);
            }
            case 2: {
                return GeometryWkbFormatCodec.decodeLineString(buffer, srid);
            }
            case 3: {
                return GeometryWkbFormatCodec.decodePolygon(buffer, srid);
            }
            case 4: {
                return GeometryWkbFormatCodec.decodeMultiPoint(buffer, srid);
            }
            case 5: {
                return GeometryWkbFormatCodec.decodeMultiLineString(buffer, srid);
            }
            case 6: {
                return GeometryWkbFormatCodec.decodeMultiPolygon(buffer, srid);
            }
            case 7: {
                return GeometryWkbFormatCodec.decodeGeometryCollection(buffer, srid);
            }
        }
        LOGGER.error((Object)String.format("Error when parsing unknown geometry data type, wkbTypeId=[%d]", type));
        return null;
    }

    private static Point decodePoint(ByteBuf buffer, long srid) {
        double x = buffer.readDoubleLE();
        double y = buffer.readDoubleLE();
        return new Point(srid, x, y);
    }

    private static LineString decodeLineString(ByteBuf buffer, long srid) {
        long numPoints = buffer.readUnsignedIntLE();
        ArrayList<Point> points = new ArrayList<Point>();
        for (long i = 0L; i < numPoints; ++i) {
            Point point = GeometryWkbFormatCodec.decodePoint(buffer, srid);
            points.add(point);
        }
        return new LineString(srid, points);
    }

    private static Polygon decodePolygon(ByteBuf buffer, long srid) {
        long numRings = buffer.readUnsignedIntLE();
        ArrayList<LineString> rings = new ArrayList<LineString>();
        for (long i = 0L; i < numRings; ++i) {
            LineString linearRing = GeometryWkbFormatCodec.decodeLineString(buffer, srid);
            rings.add(linearRing);
        }
        return new Polygon(srid, rings);
    }

    private static MultiPoint decodeMultiPoint(ByteBuf buffer, long srid) {
        long numWkbPoints = buffer.readUnsignedIntLE();
        ArrayList<Point> wkbPoints = new ArrayList<Point>();
        for (long i = 0L; i < numWkbPoints; ++i) {
            buffer.skipBytes(5);
            Point wkbPoint = GeometryWkbFormatCodec.decodePoint(buffer, srid);
            wkbPoints.add(wkbPoint);
        }
        return new MultiPoint(srid, wkbPoints);
    }

    private static MultiLineString decodeMultiLineString(ByteBuf buffer, long srid) {
        long numWkbLineStrings = buffer.readUnsignedIntLE();
        ArrayList<LineString> wkbLineStrings = new ArrayList<LineString>();
        for (long i = 0L; i < numWkbLineStrings; ++i) {
            buffer.skipBytes(5);
            LineString linearRing = GeometryWkbFormatCodec.decodeLineString(buffer, srid);
            wkbLineStrings.add(linearRing);
        }
        return new MultiLineString(srid, wkbLineStrings);
    }

    private static MultiPolygon decodeMultiPolygon(ByteBuf buffer, long srid) {
        long numWkbPolygons = buffer.readUnsignedIntLE();
        ArrayList<Polygon> wkbPolygons = new ArrayList<Polygon>();
        for (long i = 0L; i < numWkbPolygons; ++i) {
            buffer.skipBytes(5);
            Polygon wkbPolygon = GeometryWkbFormatCodec.decodePolygon(buffer, srid);
            wkbPolygons.add(wkbPolygon);
        }
        return new MultiPolygon(srid, wkbPolygons);
    }

    private static GeometryCollection decodeGeometryCollection(ByteBuf buffer, long srid) {
        long numWkbGeometries = buffer.readUnsignedIntLE();
        ArrayList<Geometry> wkbGeometries = new ArrayList<Geometry>();
        for (long i = 0L; i < numWkbGeometries; ++i) {
            buffer.skipBytes(1);
            int type = buffer.readIntLE();
            Geometry geometry = (Geometry)GeometryWkbFormatCodec.decodeWkbFormatGeometry(buffer, srid, type);
            wkbGeometries.add(geometry);
        }
        return new GeometryCollection(srid, wkbGeometries);
    }

    private static void encodePointToBlob(ByteBuf buffer, Point point) {
        BufferUtils.writeLengthEncodedInteger(buffer, 21L);
        GeometryWkbFormatCodec.encodeWkbPoint(buffer, point);
    }

    private static void encodeLineStringToBlob(ByteBuf buffer, LineString lineString) {
        int bufferLength = GeometryWkbFormatCodec.calculateWkbLineStringLength(lineString);
        BufferUtils.writeLengthEncodedInteger(buffer, bufferLength);
        GeometryWkbFormatCodec.encodeWkbLineString(buffer, lineString);
    }

    private static void encodePolygonToBlob(ByteBuf buffer, Polygon polygon) {
        int bufferLength = GeometryWkbFormatCodec.calculateWkbPolygonLength(polygon);
        BufferUtils.writeLengthEncodedInteger(buffer, bufferLength);
        GeometryWkbFormatCodec.encodeWkbPolygon(buffer, polygon);
    }

    private static void encodeMultiPointToBlob(ByteBuf buffer, MultiPoint multiPoint) {
        int bufferLength = GeometryWkbFormatCodec.calculateWkbMultiPointLength(multiPoint);
        BufferUtils.writeLengthEncodedInteger(buffer, bufferLength);
        GeometryWkbFormatCodec.encodeWkbMultiPoint(buffer, multiPoint);
    }

    private static void encodeMultiLineStringToBlob(ByteBuf buffer, MultiLineString multiLineString) {
        int bufferLength = GeometryWkbFormatCodec.calculateWkbMultiLineStringLength(multiLineString);
        BufferUtils.writeLengthEncodedInteger(buffer, bufferLength);
        GeometryWkbFormatCodec.encodeWkbMultiLineString(buffer, multiLineString);
    }

    private static void encodeMultiPolygonToBlob(ByteBuf buffer, MultiPolygon multiPolygon) {
        int bufferLength = GeometryWkbFormatCodec.calculateWkbMultiPolygonLength(multiPolygon);
        BufferUtils.writeLengthEncodedInteger(buffer, bufferLength);
        GeometryWkbFormatCodec.encodeWkbMultiPolygon(buffer, multiPolygon);
    }

    private static void encodeGeometryCollectionToBlob(ByteBuf buffer, GeometryCollection geometryCollection) {
        int bufferLength = GeometryWkbFormatCodec.calculateWkbGeometryCollectionLength(geometryCollection);
        BufferUtils.writeLengthEncodedInteger(buffer, bufferLength);
        GeometryWkbFormatCodec.encodeWkbGeometryCollection(buffer, geometryCollection);
    }

    private static void encodeWkbGeometry(ByteBuf buffer, Geometry geometry) {
        if (geometry instanceof Point) {
            GeometryWkbFormatCodec.encodeWkbPoint(buffer, (Point)geometry);
        } else if (geometry instanceof LineString) {
            GeometryWkbFormatCodec.encodeWkbLineString(buffer, (LineString)geometry);
        } else if (geometry instanceof Polygon) {
            GeometryWkbFormatCodec.encodeWkbPolygon(buffer, (Polygon)geometry);
        } else if (geometry instanceof MultiPoint) {
            GeometryWkbFormatCodec.encodeWkbMultiPoint(buffer, (MultiPoint)geometry);
        } else if (geometry instanceof MultiLineString) {
            GeometryWkbFormatCodec.encodeWkbMultiLineString(buffer, (MultiLineString)geometry);
        } else if (geometry instanceof MultiPolygon) {
            GeometryWkbFormatCodec.encodeWkbMultiPolygon(buffer, (MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            GeometryWkbFormatCodec.encodeWkbGeometryCollection(buffer, (GeometryCollection)geometry);
        } else {
            LOGGER.error((Object)"Unknown type of Geometry");
        }
    }

    private static void encodeWkbPoint(ByteBuf buffer, Point wkbPoint) {
        buffer.writeByte(1);
        buffer.writeIntLE(1);
        buffer.writeDoubleLE(wkbPoint.getX());
        buffer.writeDoubleLE(wkbPoint.getY());
    }

    private static void encodeWkbLineString(ByteBuf buffer, LineString wkbLineString) {
        buffer.writeByte(1);
        buffer.writeIntLE(2);
        buffer.writeIntLE(wkbLineString.getPoints().size());
        for (Point point : wkbLineString.getPoints()) {
            buffer.writeDoubleLE(point.getX());
            buffer.writeDoubleLE(point.getY());
        }
    }

    private static void encodeWkbPolygon(ByteBuf buffer, Polygon polygon) {
        buffer.writeByte(1);
        buffer.writeIntLE(3);
        buffer.writeIntLE(polygon.getLineStrings().size());
        for (LineString lineString : polygon.getLineStrings()) {
            buffer.writeIntLE(lineString.getPoints().size());
            for (Point point : lineString.getPoints()) {
                buffer.writeDoubleLE(point.getX());
                buffer.writeDoubleLE(point.getY());
            }
        }
    }

    private static void encodeWkbMultiPoint(ByteBuf buffer, MultiPoint multiPoint) {
        buffer.writeByte(1);
        buffer.writeIntLE(4);
        buffer.writeIntLE(multiPoint.getPoints().size());
        for (Point wkbPoint : multiPoint.getPoints()) {
            GeometryWkbFormatCodec.encodeWkbPoint(buffer, wkbPoint);
        }
    }

    private static void encodeWkbMultiLineString(ByteBuf buffer, MultiLineString multiLineString) {
        buffer.writeByte(1);
        buffer.writeIntLE(5);
        buffer.writeIntLE(multiLineString.getLineStrings().size());
        for (LineString wkbLineString : multiLineString.getLineStrings()) {
            GeometryWkbFormatCodec.encodeWkbLineString(buffer, wkbLineString);
        }
    }

    private static void encodeWkbMultiPolygon(ByteBuf buffer, MultiPolygon multiPolygon) {
        buffer.writeByte(1);
        buffer.writeIntLE(6);
        buffer.writeIntLE(multiPolygon.getPolygons().size());
        for (Polygon wkbPolygon : multiPolygon.getPolygons()) {
            GeometryWkbFormatCodec.encodeWkbPolygon(buffer, wkbPolygon);
        }
    }

    private static void encodeWkbGeometryCollection(ByteBuf buffer, GeometryCollection geometryCollection) {
        buffer.writeByte(1);
        buffer.writeIntLE(7);
        buffer.writeIntLE(geometryCollection.getGeometries().size());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            GeometryWkbFormatCodec.encodeWkbGeometry(buffer, geometry);
        }
    }

    private static int calculateWkbLineStringLength(LineString lineString) {
        int numPoints = lineString.getPoints().size();
        return 9 + numPoints * 16;
    }

    private static int calculateWkbPolygonLength(Polygon polygon) {
        int numOfTotalPoints = 0;
        for (LineString lineString : polygon.getLineStrings()) {
            numOfTotalPoints += lineString.getPoints().size();
        }
        return 9 + 4 * polygon.getLineStrings().size() + numOfTotalPoints * 16;
    }

    private static int calculateWkbMultiPointLength(MultiPoint multiPoint) {
        int numWkbPoints = multiPoint.getPoints().size();
        return 9 + numWkbPoints * 21;
    }

    private static int calculateWkbMultiLineStringLength(MultiLineString multiLineString) {
        int numWkbLineStrings = multiLineString.getLineStrings().size();
        int numOfTotalPoints = 0;
        for (LineString lineString : multiLineString.getLineStrings()) {
            numOfTotalPoints += lineString.getPoints().size();
        }
        return 9 + 9 * numWkbLineStrings + numOfTotalPoints * 16;
    }

    private static int calculateWkbMultiPolygonLength(MultiPolygon multiPolygon) {
        int bufferLength = 9;
        for (Polygon polygon : multiPolygon.getPolygons()) {
            bufferLength += GeometryWkbFormatCodec.calculateWkbPolygonLength(polygon);
        }
        return bufferLength;
    }

    private static int calculateWkbGeometryCollectionLength(GeometryCollection geometryCollection) {
        int bufferLength = 9;
        for (Geometry geometry : geometryCollection.getGeometries()) {
            if (geometry instanceof Point) {
                bufferLength += 21;
                continue;
            }
            if (geometry instanceof LineString) {
                bufferLength += GeometryWkbFormatCodec.calculateWkbLineStringLength((LineString)geometry);
                continue;
            }
            if (geometry instanceof Polygon) {
                bufferLength += GeometryWkbFormatCodec.calculateWkbPolygonLength((Polygon)geometry);
                continue;
            }
            if (geometry instanceof MultiPoint) {
                bufferLength += GeometryWkbFormatCodec.calculateWkbMultiPointLength((MultiPoint)geometry);
                continue;
            }
            if (geometry instanceof MultiLineString) {
                bufferLength += GeometryWkbFormatCodec.calculateWkbMultiLineStringLength((MultiLineString)geometry);
                continue;
            }
            if (geometry instanceof MultiPolygon) {
                bufferLength += GeometryWkbFormatCodec.calculateWkbMultiPolygonLength((MultiPolygon)geometry);
                continue;
            }
            if (geometry instanceof GeometryCollection) {
                bufferLength += GeometryWkbFormatCodec.calculateWkbGeometryCollectionLength((GeometryCollection)geometry);
                continue;
            }
            LOGGER.error((Object)"Unknown type of Geometry");
            return -1;
        }
        return bufferLength;
    }
}

