/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.sqlclient.spi.DatabaseMetadata;

public class MySQLDatabaseMetadata
implements DatabaseMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDatabaseMetadata.class);
    private final System system;
    private final String fullVersion;
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;

    private MySQLDatabaseMetadata(System system, String fullVersion, int majorVersion, int minorVersion, int microVersion) {
        this.system = system;
        this.fullVersion = fullVersion;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
    }

    public static MySQLDatabaseMetadata parse(String serverVersion) {
        int versionTokenStartIdx;
        int majorVersion = 0;
        int minorVersion = 0;
        int microVersion = 0;
        int len = serverVersion.length();
        System system = serverVersion.contains("MariaDB") ? System.MARIA_DB : System.MYSQL;
        String fullServerVersion = serverVersion;
        if (system == System.MARIA_DB) {
            serverVersion = serverVersion.replace("5.5.5-", "");
        }
        String versionToken = null;
        for (int versionTokenEndIdx = versionTokenStartIdx = 0; versionTokenEndIdx < len; ++versionTokenEndIdx) {
            char c = serverVersion.charAt(versionTokenEndIdx);
            if (c != '-' && c != ' ') continue;
            versionToken = serverVersion.substring(versionTokenStartIdx, versionTokenEndIdx);
            break;
        }
        if (versionToken == null) {
            versionToken = serverVersion;
        }
        String[] versionTokens = versionToken.split("\\.");
        try {
            majorVersion = Integer.parseInt(versionTokens[0]);
            minorVersion = Integer.parseInt(versionTokens[1]);
            microVersion = Integer.parseInt(versionTokens[2]);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"Incorrect parsing server version tokens", (Throwable)ex);
        }
        return new MySQLDatabaseMetadata(system, fullServerVersion, majorVersion, minorVersion, microVersion);
    }

    public String system() {
        return this.system.value;
    }

    public String productName() {
        return this.system.productName;
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int microVersion() {
        return this.microVersion;
    }

    private static enum System {
        MYSQL("mysql", "MySQL"),
        MARIA_DB("mariadb", "MariaDB");

        final String value;
        final String productName;

        private System(String value, String productName) {
            this.value = value;
            this.productName = productName;
        }
    }
}

