/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.sqlclient.internal.command.CloseStatementCommand;
import io.vertx.sqlclient.internal.command.CommandResponse;

class CloseStatementCommandCodec
extends CommandCodec<Void, CloseStatementCommand> {
    private static final int PAYLOAD_LENGTH = 5;

    CloseStatementCommandCodec(CloseStatementCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        MySQLPreparedStatement statement = (MySQLPreparedStatement)((CloseStatementCommand)this.cmd).statement();
        this.sendCloseStatementCommand(statement);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        this.encoder.fireCommandResponse(CommandResponse.success(null));
    }

    private void sendCloseStatementCommand(MySQLPreparedStatement statement) {
        ByteBuf packet = this.allocateBuffer(9);
        packet.writeMediumLE(5);
        packet.writeByte(this.sequenceId);
        packet.writeByte(25);
        packet.writeIntLE((int)statement.statementId);
        this.sendNonSplitPacket(packet);
    }

    @Override
    boolean expectNoResponsePacket() {
        return true;
    }
}

