/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.MySQLAuthOptionsConverter;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.impl.MySQLCollation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class MySQLAuthOptions {
    private String user;
    private String password;
    private String database;
    private String collation;
    private String charset;
    private String serverRsaPublicKeyPath;
    private Buffer serverRsaPublicKeyValue;
    private Map<String, String> properties;

    public MySQLAuthOptions() {
        this.init();
    }

    public MySQLAuthOptions(JsonObject json) {
        this.init();
        MySQLAuthOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public MySQLAuthOptions(MySQLAuthOptions other) {
        this.init();
        this.user = other.user;
        this.password = other.password;
        this.database = other.database;
        this.collation = other.collation;
        this.charset = other.charset;
        this.serverRsaPublicKeyPath = other.serverRsaPublicKeyPath;
        this.serverRsaPublicKeyValue = other.serverRsaPublicKeyValue != null ? other.serverRsaPublicKeyValue.copy() : null;
        this.properties = new HashMap<String, String>(other.properties);
    }

    public String getUser() {
        return this.user;
    }

    public MySQLAuthOptions setUser(String user) {
        Objects.requireNonNull(user, "User account can not be null");
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public MySQLAuthOptions setPassword(String password) {
        Objects.requireNonNull(password, "Password can not be null");
        this.password = password;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public MySQLAuthOptions setDatabase(String database) {
        Objects.requireNonNull(database, "Database name can not be null");
        this.database = database;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public MySQLAuthOptions setProperties(Map<String, String> properties) {
        Objects.requireNonNull(properties, "Properties can not be null");
        this.properties = properties;
        return this;
    }

    @GenIgnore
    public MySQLAuthOptions addProperty(String key, String value) {
        Objects.requireNonNull(key, "Property key can not be null");
        Objects.requireNonNull(value, "Property value can not be null");
        this.properties.put(key, value);
        return this;
    }

    public String getCollation() {
        return this.collation;
    }

    public MySQLAuthOptions setCollation(String collation) {
        if (collation != null && !MySQLCollation.SUPPORTED_COLLATION_NAMES.contains(collation)) {
            throw new IllegalArgumentException("Unsupported collation: " + collation);
        }
        this.collation = collation;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public MySQLAuthOptions setCharset(String charset) {
        if (charset != null && !MySQLCollation.SUPPORTED_CHARSET_NAMES.contains(charset)) {
            throw new IllegalArgumentException("Unsupported charset: " + charset);
        }
        this.charset = charset;
        return this;
    }

    public String getServerRsaPublicKeyPath() {
        return this.serverRsaPublicKeyPath;
    }

    public MySQLAuthOptions setServerRsaPublicKeyPath(String serverRsaPublicKeyPath) {
        this.serverRsaPublicKeyPath = serverRsaPublicKeyPath;
        return this;
    }

    public Buffer getServerRsaPublicKeyValue() {
        return this.serverRsaPublicKeyValue;
    }

    public MySQLAuthOptions setServerRsaPublicKeyValue(Buffer serverRsaPublicKeyValue) {
        this.serverRsaPublicKeyValue = serverRsaPublicKeyValue;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        MySQLAuthOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.user = "root";
        this.password = "";
        this.database = "";
        this.charset = "utf8mb4";
        this.properties = new HashMap<String, String>(MySQLConnectOptions.DEFAULT_CONNECTION_ATTRIBUTES);
    }
}

