/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.sqlclient.internal.command.CloseCursorCommand;

class ResetStatementCommandCodec
extends CommandCodec<Void, CloseCursorCommand> {
    private static final int PAYLOAD_LENGTH = 5;

    ResetStatementCommandCodec(CloseCursorCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        MySQLPreparedStatement statement = (MySQLPreparedStatement)((CloseCursorCommand)this.cmd).statement();
        statement.cleanBindings();
        statement.isCursorOpen = false;
        this.sendStatementResetCommand(statement.statementId);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        this.handleOkPacketOrErrorPacketPayload(payload);
    }

    private void sendStatementResetCommand(long statementId) {
        ByteBuf packet = this.allocateBuffer(9);
        packet.writeMediumLE(5);
        packet.writeByte(this.sequenceId);
        packet.writeByte(26);
        packet.writeIntLE((int)statementId);
        this.sendNonSplitPacket(packet);
    }
}

