/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.sqlclient.SqlConnection;

@VertxGen
public interface MySQLConnection
extends SqlConnection {
    public static Future<MySQLConnection> connect(Vertx vertx, MySQLConnectOptions connectOptions) {
        return MySQLConnectionImpl.connect((ContextInternal)vertx.getOrCreateContext(), connectOptions);
    }

    public static Future<MySQLConnection> connect(Vertx vertx, String connectionUri) {
        return MySQLConnection.connect(vertx, MySQLConnectOptions.fromUri(connectionUri));
    }

    @Fluent
    public MySQLConnection exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public MySQLConnection closeHandler(Handler<Void> var1);

    public Future<Void> ping();

    public Future<Void> specifySchema(String var1);

    public Future<String> getInternalStatistics();

    public Future<Void> setOption(MySQLSetOption var1);

    public Future<Void> resetConnection();

    public Future<Void> debug();

    public Future<Void> changeUser(MySQLAuthOptions var1);

    public static MySQLConnection cast(SqlConnection sqlConnection) {
        return (MySQLConnection)sqlConnection;
    }
}

