/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.SetOptionCommand;

class SetOptionCommandCodec
extends CommandCodec<Void, SetOptionCommand> {
    private static final int PAYLOAD_LENGTH = 3;

    SetOptionCommandCodec(SetOptionCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendSetOptionCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        this.handleOkPacketOrErrorPacketPayload(payload);
    }

    private void sendSetOptionCommand() {
        ByteBuf packet = this.allocateBuffer(7);
        packet.writeMediumLE(3);
        packet.writeByte(this.sequenceId);
        packet.writeByte(27);
        packet.writeShortLE(((SetOptionCommand)this.cmd).option().ordinal());
        this.sendNonSplitPacket(packet);
    }
}

