/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.StatisticsCommand;
import io.vertx.sqlclient.impl.command.CommandResponse;

class StatisticsCommandCodec
extends CommandCodec<String, StatisticsCommand> {
    private static final int PAYLOAD_LENGTH = 1;

    StatisticsCommandCodec(StatisticsCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendStatisticsCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        this.encoder.fireCommandResponse(CommandResponse.success((Object)payload.toString()));
    }

    private void sendStatisticsCommand() {
        ByteBuf packet = this.allocateBuffer(5);
        packet.writeMediumLE(1);
        packet.writeByte(this.sequenceId);
        packet.writeByte(9);
        this.sendNonSplitPacket(packet);
    }
}

