/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.CachedParameterMetaData;
import io.vertx.ext.jdbc.impl.actions.CallableOutParams;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.spi.JDBCColumnDescriptorProvider;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOptions;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Collections;

public class JDBCCallable
extends AbstractJDBCAction<ResultSet> {
    private final String sql;
    private final JsonArray in;
    private final JsonArray out;

    public JDBCCallable(JDBCStatementHelper helper, SQLOptions options, String sql, JsonArray in, JsonArray out) {
        super(helper, options);
        this.sql = sql;
        this.in = in;
        this.out = out;
    }

    @Override
    public ResultSet execute(Connection conn) throws SQLException {
        try (CallableStatement statement = conn.prepareCall(this.sql);){
            this.applyStatementOptions(statement);
            CallableOutParams outParams = JDBCCallable.createOutParams(this.out);
            ParameterMetaData md = new CachedParameterMetaData(statement).putOutParams(outParams);
            JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromParameterMetaData(md);
            this.fillStatement(statement, this.in, this.out, provider);
            boolean retResult = statement.execute();
            ResultSet resultSet = null;
            if (retResult) {
                ResultSet ref = null;
                while (retResult) {
                    try (java.sql.ResultSet rs = statement.getResultSet();){
                        if (ref == null) {
                            ref = resultSet = this.asList(rs);
                        } else {
                            ref.setNext(this.asList(rs));
                            ref = ref.getNext();
                        }
                        if (!outParams.isEmpty()) {
                            ref.setOutput(this.convertOutputs(statement, provider));
                        }
                    }
                    retResult = statement.getMoreResults();
                }
            } else if (!outParams.isEmpty()) {
                resultSet = new ResultSet(Collections.emptyList(), Collections.emptyList(), null).setOutput(this.convertOutputs(statement, provider));
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
    }

    private JsonArray convertOutputs(CallableStatement statement, JDBCColumnDescriptorProvider provider) throws SQLException {
        JsonArray result = new JsonArray();
        for (int i = 0; i < this.out.size(); ++i) {
            Object var = this.out.getValue(i);
            if (var != null) {
                Object value = statement.getObject(i + 1);
                if (value == null) {
                    result.addNull();
                    continue;
                }
                if (value instanceof java.sql.ResultSet) {
                    result.add((Object)this.asList((java.sql.ResultSet)value).toJson());
                    continue;
                }
                result.add(this.helper.getDecoder().parse(statement, i + 1, provider));
                continue;
            }
            result.addNull();
        }
        return result;
    }

    private static CallableOutParams createOutParams(JsonArray out) {
        CallableOutParams params = CallableOutParams.create();
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                Object param = out.getValue(i);
                if (param instanceof Integer) {
                    params.put((Integer)(i + 1), (Integer)param);
                    continue;
                }
                if (param instanceof JDBCType) {
                    params.put((Integer)(i + 1), (JDBCType)param);
                    continue;
                }
                if (param == null) continue;
                params.put((Integer)(i + 1), param.toString());
            }
        }
        return params;
    }
}

